/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Graphics;
import java.awt.Rectangle;
import objectdraw.Bounds;
import objectdraw.DrawingCanvas;
import objectdraw.Location;
import objectdraw.Rect;

public class FilledArc
extends Rect {
    private int startangle = 0;
    private int arcangle = 0;

    public FilledArc(Location location, double d, double d2, double d3, double d4, DrawingCanvas drawingCanvas) {
        super(location, d, d2);
        this.startangle = (int)d3;
        this.arcangle = (int)d4;
        this.addToCanvas(drawingCanvas);
    }

    public FilledArc(double d, double d2, double d3, double d4, double d5, double d6, DrawingCanvas drawingCanvas) {
        this(new Location(d, d2), d3, d4, d5, d6, drawingCanvas);
    }

    public FilledArc(Location location, Location location2, double d, double d2, DrawingCanvas drawingCanvas) {
        this(location, location2.getX() - location.getX(), location2.getY() - location.getY(), d, d2, drawingCanvas);
    }

    public double getStartAngle() {
        return this.startangle;
    }

    public double getArcAngle() {
        return this.arcangle;
    }

    public synchronized void setStartAngle(double d) {
        this.startangle = (int)d;
        this.setStateChanged();
    }

    public synchronized void setArcAngle(double d) {
        this.arcangle = (int)d;
        this.setStateChanged();
    }

    public synchronized void draw(Graphics graphics) {
        Bounds bounds = this.getBounds();
        if (bounds != null) {
            super.draw(graphics);
            Rectangle rectangle = this.getBounds().toRectangle();
            graphics.fillArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.startangle, this.arcangle);
        }
    }

    public String toString() {
        Bounds bounds = this.getBounds();
        Location location = bounds.getLocation();
        return "FilledArc at " + location.getX() + "," + location.getY() + " width:" + bounds.getWidth() + " height:" + bounds.getHeight() + " startangle:" + this.startangle + " arcangle:" + this.arcangle + " color:" + this.getColor().toString();
    }
}

