/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import objectdraw.CanvasManager;
import objectdraw.DrawableInterface;
import objectdraw.DrawingCanvas;
import objectdraw.Location;

public abstract class Drawable
implements DrawableInterface,
Serializable {
    protected transient DrawingCanvas canvas;
    protected transient CanvasManager canvasContent;
    protected Color color = Color.black;
    protected boolean shown = true;
    protected static final boolean DEBUGGING = false;

    DrawingCanvas getCanvas() {
        return this.canvas;
    }

    void setCanvas(DrawingCanvas drawingCanvas) {
        this.canvas = drawingCanvas;
        this.canvasContent = this.canvas.getCanvasContent();
    }

    public void addToCanvas(DrawingCanvas drawingCanvas) {
        drawingCanvas.addToCanvas(this);
    }

    public void removeFromCanvas() {
        this.canvas.removeFromCanvas(this);
    }

    public void setStateChanged() {
        this.canvasContent.setStateChanged();
    }

    public synchronized void draw(Graphics graphics) {
        graphics.setColor(this.color);
    }

    public synchronized void hide() {
        this.shown = false;
        this.setStateChanged();
    }

    public synchronized void show() {
        this.shown = true;
        this.setStateChanged();
    }

    public boolean isHidden() {
        return this.shown ^ true;
    }

    public abstract void moveTo(Location var1);

    public synchronized void moveTo(double d, double d2) {
        this.moveTo(new Location(d, d2));
    }

    public abstract void move(double var1, double var3);

    public abstract boolean contains(Location var1);

    public synchronized void setColor(Color color) {
        this.color = color;
        this.setStateChanged();
    }

    public Color getColor() {
        return this.color;
    }

    public void sendForward() {
        this.canvasContent.sendObjectForward(this);
    }

    public void sendBackward() {
        this.canvasContent.sendObjectBackward(this);
    }

    public void sendToFront() {
        this.canvasContent.sendObjectToFront(this);
    }

    public void sendToBack() {
        this.canvasContent.sendObjectToBack(this);
    }
}

