/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import objectdraw.ActiveObject;
import objectdraw.TerminateEvent;
import objectdraw.UnintSuspendEvent;

public class Controller
extends Applet {
    private UnintSuspendEvent stopper;

    protected void setup() {
        this.setLayout(new BorderLayout());
    }

    public void init() {
        this.setup();
        this.validate();
        this.begin();
        this.validate();
    }

    protected void begin() {
    }

    protected synchronized Image getImage(String string) {
        Image image;
        try {
            image = string.substring(0, 4).equals("http") ? this.getImage(new URL(string)) : this.getImage(this.getClass().getResource(string));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Invalid Image path - " + string);
            return null;
        }
        return image;
    }

    protected synchronized AudioClip getAudio(String string) {
        AudioClip audioClip;
        try {
            audioClip = string.substring(0, 4).equals("http") ? this.getAudioClip(new URL(string)) : this.getAudioClip(this.getClass().getResource(string));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Invalid Sound path - " + string);
            return null;
        }
        return audioClip;
    }

    public static synchronized double getTime() {
        return new Date().getTime();
    }

    public synchronized void start() {
        if (this.stopper != null) {
            this.stopper.resume();
            this.stopper = null;
        }
    }

    public synchronized void stop() {
        if (this.stopper == null) {
            this.stopper = new UnintSuspendEvent();
            ActiveObject.scheduleClassEvent(this.stopper);
        }
    }

    public synchronized void destroy() {
        TerminateEvent terminateEvent = new TerminateEvent();
        ActiveObject.scheduleClassEvent(terminateEvent);
    }
}

