/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import objectdraw.Drawable;
import objectdraw.DrawableInterface;
import objectdraw.DrawingCanvas;

public class CanvasManager {
    public static final Dimension DEFAULT_PREFERRED_SIZE = new Dimension(400, 400);
    private DrawingCanvas canvas;
    private Dimension preferred_dim;
    private Dimension bufSize;
    private Vector objects;
    private Image buffer;
    private Graphics buffer_gc;
    private boolean stateChanged;
    private boolean enableRepaint;

    public CanvasManager(Dimension dimension, DrawingCanvas drawingCanvas) {
        this.preferred_dim = dimension;
        this.objects = new Vector();
        this.canvas = drawingCanvas;
        this.canvas.setForeground(Color.black);
        this.canvas.setBackground(Color.white);
        this.stateChanged = false;
        this.enableRepaint = true;
        this.canvas.addComponentListener(this.canvas);
    }

    public synchronized void addToCanvas(Drawable drawable) {
        if (drawable.getCanvas() == null || !this.objectInCanvas(drawable)) {
            drawable.setCanvas(this.canvas);
            this.add(drawable);
        }
    }

    public synchronized void removeFromCanvas(Drawable drawable) {
        this.remove(drawable);
    }

    private boolean objectInCanvas(Drawable drawable) {
        return this.objects.contains(drawable);
    }

    public synchronized void add(DrawableInterface drawableInterface) {
        this.objects.addElement(drawableInterface);
        if (this.buffer == null) {
            this.createBuffer();
        }
        this.setStateChanged();
    }

    public synchronized void remove(DrawableInterface drawableInterface) {
        this.objects.removeElement(drawableInterface);
        this.setStateChanged();
    }

    public synchronized void clear() {
        this.objects.removeAllElements();
        this.setStateChanged();
    }

    public void setStateChanged() {
        this.stateChanged = true;
        if (this.enableRepaint) {
            this.repaint();
        }
    }

    public synchronized void paint(Graphics graphics) {
        if (this.buffer == null || !this.bufSize.equals(this.canvas.getSize())) {
            this.stateChanged = true;
            this.createBuffer();
        }
        if (this.stateChanged) {
            this.redraw();
        }
        graphics.drawImage(this.buffer, 0, 0, this.canvas);
    }

    public synchronized void redraw() {
        this.stateChanged = false;
        this.buffer_gc.setColor(this.canvas.getBackground());
        this.buffer_gc.fillRect(0, 0, this.canvas.getSize().width, this.canvas.getSize().height);
        int n = 0;
        while (n < this.objects.size()) {
            DrawableInterface drawableInterface = (DrawableInterface)this.objects.elementAt(n);
            if (!drawableInterface.isHidden()) {
                drawableInterface.draw(this.buffer_gc);
            }
            ++n;
        }
    }

    public void repaint() {
        this.canvas.repaint();
    }

    public void enableAutoRepaint() {
        this.enableRepaint = true;
    }

    public void disableAutoRepaint() {
        this.enableRepaint = false;
    }

    public synchronized void sendObjectToFront(DrawableInterface drawableInterface) {
        if (!this.objects.isEmpty() && drawableInterface != null) {
            this.objects.removeElement(drawableInterface);
            this.objects.addElement(drawableInterface);
            this.setStateChanged();
        }
    }

    public synchronized void sendObjectToBack(DrawableInterface drawableInterface) {
        this.objects.removeElement(drawableInterface);
        this.objects.insertElementAt(drawableInterface, 0);
        this.setStateChanged();
    }

    public synchronized void sendObjectForward(DrawableInterface drawableInterface) {
        int n = this.objects.indexOf(drawableInterface);
        if (n < this.objects.size() - 1) {
            DrawableInterface drawableInterface2 = (DrawableInterface)this.objects.elementAt(n + 1);
            this.objects.setElementAt(drawableInterface2, n);
            this.objects.setElementAt(drawableInterface, n + 1);
            this.setStateChanged();
        }
    }

    public synchronized void sendObjectBackward(DrawableInterface drawableInterface) {
        int n = this.objects.indexOf(drawableInterface);
        if (n > 0) {
            DrawableInterface drawableInterface2 = (DrawableInterface)this.objects.elementAt(n - 1);
            this.objects.setElementAt(drawableInterface2, n);
            this.objects.setElementAt(drawableInterface, n - 1);
            this.setStateChanged();
        }
    }

    private synchronized void createBuffer() {
        Image image;
        this.bufSize = this.canvas.getSize();
        this.buffer = image = this.canvas.createImage(this.canvas.getWidth(), this.canvas.getHeight());
        if (this.buffer != null) {
            this.buffer_gc = this.buffer.getGraphics();
        }
    }
}

