/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Rectangle;
import objectdraw.Location;

public class Bounds {
    private double x;
    private double y;
    private double width;
    private double height;

    public Bounds(Location location, double d, double d2) {
        this(location.getX(), location.getY(), d, d2);
    }

    public Bounds(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public Bounds(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Bounds(Bounds bounds) {
        this(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public synchronized Location getLocation() {
        return new Location(this.x, this.y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public synchronized void setLocation(Location location) {
        this.x = location.getX();
        this.y = location.getY();
    }

    public synchronized void setLocation(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public synchronized void setWidth(double d) {
        this.width = d;
    }

    public synchronized void setHeight(double d) {
        this.height = d;
    }

    public synchronized void setDimensions(double d, double d2) {
        this.setWidth(d);
        this.setHeight(d2);
    }

    public synchronized void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public synchronized boolean contains(Location location) {
        boolean bl = location.getX() >= this.x && location.getY() >= this.y;
        bl = bl && location.getX() <= this.x + this.width && location.getY() <= this.y + this.height;
        return bl;
    }

    public synchronized boolean intersects(Bounds bounds) {
        boolean bl = false;
        bl = this.contains(bounds.getLocation()) || bounds.contains(this.getLocation());
        bl = bl || this.contains(new Location(bounds.x + bounds.width, bounds.y)) || bounds.contains(new Location(this.x + this.width, this.y));
        bl = bl || this.contains(new Location(bounds.x, bounds.y + bounds.height)) || bounds.contains(new Location(this.x, this.y + this.height));
        bl = bl || this.contains(new Location(bounds.x + bounds.width, bounds.y + bounds.height)) || bounds.contains(new Location(this.x + this.width, this.y + this.height));
        return bl;
    }

    public synchronized Rectangle toRectangle() {
        Rectangle rectangle = new Rectangle(this.getLocation().toPoint());
        rectangle.width = (int)Math.rint(this.width);
        rectangle.height = (int)Math.rint(this.height);
        return rectangle;
    }

    public String toString() {
        return "Bounds at " + this.getLocation().toString() + " width=" + this.width + "height=" + this.height;
    }
}

