/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.util.Date;
import objectdraw.ActiveObject;
import objectdraw.ActiveObjectEventInterface;

public class ActiveObject
extends Thread {
    private final EventDeque EVENT_DEQUE = new EventDeque();
    private final EventIterator CLASS_EVENT_ITERATOR = CLASS_EVENT_LIST.getEventIterator();
    private static final EventList CLASS_EVENT_LIST = new EventList();

    public ActiveObject() {
        ActiveObject.introspect();
    }

    public ActiveObject(Runnable runnable) {
        super(runnable);
        ActiveObject.introspect();
    }

    public ActiveObject(Runnable runnable, String string) {
        super(runnable, string);
        ActiveObject.introspect();
    }

    public ActiveObject(String string) {
        super(string);
        ActiveObject.introspect();
    }

    public ActiveObject(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
        ActiveObject.introspect();
    }

    public ActiveObject(ThreadGroup threadGroup, Runnable runnable, String string) {
        super(threadGroup, runnable, string);
        ActiveObject.introspect();
    }

    public ActiveObject(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
        ActiveObject.introspect();
    }

    public void scheduleEvent(ActiveObjectEventInterface activeObjectEventInterface) {
        this.EVENT_DEQUE.put(activeObjectEventInterface);
    }

    public static void introspect() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ActiveObject) {
            ActiveObject activeObject = (ActiveObject)thread;
            ActiveObjectEventInterface activeObjectEventInterface = activeObject.CLASS_EVENT_ITERATOR.getNext();
            while (activeObjectEventInterface != null) {
                activeObjectEventInterface.execute();
                activeObjectEventInterface = activeObject.CLASS_EVENT_ITERATOR.getNext();
            }
            ActiveObjectEventInterface activeObjectEventInterface2 = activeObject.EVENT_DEQUE.poll();
            while (activeObjectEventInterface2 != null) {
                activeObjectEventInterface2.execute();
                activeObjectEventInterface2 = activeObject.EVENT_DEQUE.poll();
            }
        }
    }

    public static void defer() {
        ActiveObject.introspect();
        Thread.yield();
    }

    public static void pause(long l) {
        ActiveObject.pause(l, 0);
    }

    public static void pause(double d) {
        ActiveObject.pause(Math.round(d), 0);
    }

    public static void pause(long l, int n) {
        ActiveObject.introspect();
        try {
            Thread.sleep(l, n);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static double getTime() {
        return new Date().getTime();
    }

    public static void scheduleClassEvent(ActiveObjectEventInterface activeObjectEventInterface) {
        CLASS_EVENT_LIST.add(activeObjectEventInterface);
    }

    private static class EventDeque {
        private EventNode head;
        private EventNode tail;
        private final Object PUT_LOCK;
        private final Object PUSH_LOCK;

        public EventDeque() {
            this.tail = this.head = new EventNode(null);
            this.PUT_LOCK = new Object();
            this.PUSH_LOCK = new Object();
        }

        public void put(ActiveObjectEventInterface activeObjectEventInterface) {
            if (activeObjectEventInterface != null) {
                EventNode eventNode = new EventNode(activeObjectEventInterface);
                Object object = this.PUT_LOCK;
                synchronized (object) {
                    this.tail.setNext(eventNode);
                    this.tail = eventNode;
                }
            } else {
                throw new NullPointerException();
            }
        }

        public void push(ActiveObjectEventInterface activeObjectEventInterface) {
            if (activeObjectEventInterface != null) {
                EventNode eventNode = new EventNode(null);
                Object object = this.PUSH_LOCK;
                synchronized (object) {
                    eventNode.setNext(this.head);
                    this.head.setEvent(activeObjectEventInterface);
                    this.head = eventNode;
                }
            } else {
                throw new NullPointerException();
            }
        }

        public ActiveObjectEventInterface poll() {
            Object object = this.PUSH_LOCK;
            synchronized (object) {
                ActiveObjectEventInterface activeObjectEventInterface = null;
                EventNode eventNode = this.head.getNext();
                if (eventNode != null) {
                    activeObjectEventInterface = eventNode.getEvent();
                    eventNode.setEvent(null);
                    this.head = eventNode;
                }
                ActiveObjectEventInterface activeObjectEventInterface2 = activeObjectEventInterface;
                Object var3_5 = null;
                return activeObjectEventInterface2;
            }
        }
    }

    private static class EventList {
        private final EventNode HEAD;
        private EventNode tail;
        private final Object ADD_LOCK;

        public EventList() {
            this.tail = this.HEAD = new EventNode(null);
            this.ADD_LOCK = new Object();
        }

        public void add(ActiveObjectEventInterface activeObjectEventInterface) {
            if (activeObjectEventInterface != null) {
                EventNode eventNode = new EventNode(activeObjectEventInterface);
                Object object = this.ADD_LOCK;
                synchronized (object) {
                    this.tail.setNext(eventNode);
                    this.tail = eventNode;
                }
            } else {
                throw new NullPointerException();
            }
            if (Math.random() < 0.1) {
                this.trim();
            }
        }

        public EventIterator getEventIterator() {
            return new 1(this);
        }

        private void trim() {
            EventNode eventNode = this.HEAD;
            EventNode eventNode2 = null;
            EventNode eventNode3 = null;
            while (eventNode != null) {
                eventNode3 = eventNode2 = eventNode.getNext();
                while (eventNode3 != null && eventNode3.getEvent().isExpired()) {
                    eventNode3 = eventNode3.getNext();
                }
                if (eventNode3 != eventNode2 && eventNode3 != null) {
                    eventNode.setNext(eventNode3);
                }
                eventNode = eventNode3;
            }
        }

        static /* synthetic */ EventNode access$0(EventList eventList) {
            return eventList.HEAD;
        }
    }

    private static interface EventIterator {
        public ActiveObjectEventInterface getNext();
    }

    private static class EventNode {
        private ActiveObjectEventInterface event = null;
        private EventNode next = null;
        private final Object NEXT_LOCK = new Object();

        public EventNode(ActiveObjectEventInterface activeObjectEventInterface) {
            this.event = activeObjectEventInterface;
        }

        public ActiveObjectEventInterface getEvent() {
            return this.event;
        }

        public void setEvent(ActiveObjectEventInterface activeObjectEventInterface) {
            this.event = activeObjectEventInterface;
        }

        public EventNode getNext() {
            Object object = this.NEXT_LOCK;
            synchronized (object) {
                EventNode eventNode = this.next;
                Object var3_3 = null;
                return eventNode;
            }
        }

        public void setNext(EventNode eventNode) {
            Object object = this.NEXT_LOCK;
            synchronized (object) {
                this.next = eventNode;
            }
        }
    }
}

