/*
 * Decompiled with CFR 0.152.
 */
package objectdraw;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import objectdraw.CanvasManager;
import objectdraw.Drawable;
import objectdraw.DrawingCanvas;

public class AWTDrawingCanvas
extends Canvas
implements DrawingCanvas,
ComponentListener {
    private Dimension preferred_dim;
    private CanvasManager canvasContent;
    public static final Dimension DEFAULT_PREFERRED_SIZE = new Dimension(400, 400);

    public AWTDrawingCanvas() {
        this(DEFAULT_PREFERRED_SIZE);
    }

    public AWTDrawingCanvas(int n, int n2) {
        this(new Dimension(n, n2));
    }

    public AWTDrawingCanvas(Dimension dimension) {
        this.canvasContent = new CanvasManager(dimension, this);
        this.preferred_dim = dimension;
    }

    public Dimension getPreferredSize() {
        return this.preferred_dim;
    }

    public CanvasManager getCanvasContent() {
        return this.canvasContent;
    }

    public synchronized void addToCanvas(Drawable drawable) {
        this.canvasContent.addToCanvas(drawable);
    }

    public synchronized void removeFromCanvas(Drawable drawable) {
        this.canvasContent.removeFromCanvas(drawable);
    }

    public synchronized void clear() {
        this.canvasContent.clear();
    }

    public synchronized void paint(Graphics graphics) {
        this.canvasContent.paint(graphics);
    }

    public synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void enableAutoRepaint() {
        this.canvasContent.enableAutoRepaint();
    }

    public synchronized void disableAutoRepaint() {
        this.canvasContent.disableAutoRepaint();
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.canvasContent.setStateChanged();
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }
}

