/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JTextArea;

public class RecMazeSolver
extends Thread
implements MazeSolverInterface {
    protected static final int SLEEP_TIME = 1000;
    protected MazeGrid grid;
    protected Position start;
    protected Position finish;
    protected GraphicsMaze gm;
    protected int sleepTime;
    protected JTextArea stackDisplay;
    protected Position current;
    protected boolean success;
    protected boolean keepRunning = true;

    public RecMazeSolver(GraphicsMaze gm, MazeGrid grid, Position start, Position finish, int speed, JTextArea stackDisplay) {
        this.grid = grid;
        this.start = start;
        this.finish = finish;
        this.gm = gm;
        gm.showStatus("Starting to solve");
        this.setSpeed(speed);
        this.stackDisplay = stackDisplay;
    }

    public void stopRunning() {
        this.keepRunning = false;
    }

    public void run() {
        this.success = false;
        this.current = this.start;
        this.runMaze();
        if (this.success) {
            this.grid.setFinish(this.finish);
            this.gm.showStatus("success!");
        } else {
            this.gm.showStatus("failure");
        }
        System.out.println(this.gm.toString());
        if (!this.keepRunning) {
            this.stackDisplay.setText("Path contents:\n");
        }
    }

    public void runMaze() {
        if (this.keepRunning) {
            Position origCurrent = this.current;
            this.success = this.current.equals(this.finish);
            this.grid.visit(this.current);
            this.stackDisplay.append("\n" + this.current.toString());
            try {
                while (this.current != null && this.keepRunning && !this.success) {
                    RecMazeSolver.sleep(this.sleepTime);
                    this.current = this.nextUnvisited(this.current);
                    if (this.current != null) {
                        this.grid.visit(this.current);
                        this.gm.showStatus("Now at (" + this.current.getRow() + "," + this.current.getCol() + ").");
                        this.runMaze();
                        this.current = origCurrent;
                        continue;
                    }
                    this.removeLastOnStackDisplay();
                    this.grid.fail(origCurrent);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected Position nextUnvisited(Position current) {
        Position nextTry = current.getNorth();
        if (!(this.grid.canVisit(nextTry) || this.grid.canVisit(nextTry = current.getEast()) || this.grid.canVisit(nextTry = current.getSouth()) || this.grid.canVisit(nextTry = current.getWest()))) {
            nextTry = null;
        }
        return nextTry;
    }

    protected void removeLastOnStackDisplay() {
        String text = this.stackDisplay.getText();
        int newLast = text.lastIndexOf(10);
        this.stackDisplay.setText(text.substring(0, newLast));
    }

    public void setSpeed(int speed) {
        this.sleepTime = 1000 / speed;
    }
}

