/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JTextArea;
import net.datastructures.NodeStack;

public class MazeSolver
extends Thread
implements MazeSolverInterface {
    protected static final int SLEEP_TIME = 1000;
    protected MazeGrid grid;
    protected Position start;
    protected Position finish;
    protected GraphicsMaze gm;
    protected int sleepTime;
    protected JTextArea stackDisplay;
    protected boolean keepRunning = true;

    public MazeSolver(GraphicsMaze gm, MazeGrid grid, Position start, Position finish, int speed, JTextArea stackDisplay) {
        this.grid = grid;
        this.start = start;
        this.finish = finish;
        this.gm = gm;
        gm.showStatus("Starting to solve");
        this.setSpeed(speed);
        this.stackDisplay = stackDisplay;
    }

    public void stopRunning() {
        this.keepRunning = false;
    }

    public void run() {
        boolean success = false;
        Position current = this.start;
        NodeStack path = new NodeStack();
        this.grid.visit(current);
        path.push((Object)current);
        this.stackDisplay.append("\n" + current.toString());
        try {
            while (!path.isEmpty() && this.keepRunning && !success) {
                MazeSolver.sleep(this.sleepTime);
                current = this.nextUnvisited(current);
                if (current != null) {
                    this.grid.visit(current);
                    this.gm.showStatus("Now at (" + current.getRow() + "," + current.getCol() + ").");
                    path.push((Object)current);
                    this.stackDisplay.append("\n" + current.toString());
                    success = current.equals(this.finish);
                    continue;
                }
                current = (Position)path.pop();
                this.removeLastOnStackDisplay();
                this.grid.fail(current);
                if (path.isEmpty()) continue;
                current = (Position)path.top();
            }
            if (success) {
                this.grid.setFinish(this.finish);
                this.gm.showStatus("success!");
            } else {
                this.gm.showStatus("failure");
            }
            System.out.println(this.gm.toString());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.keepRunning) {
            this.stackDisplay.setText("Path contents:\n");
        }
    }

    protected Position nextUnvisited(Position current) {
        Position nextTry = current.getNorth();
        if (!(this.grid.canVisit(nextTry) || this.grid.canVisit(nextTry = current.getEast()) || this.grid.canVisit(nextTry = current.getSouth()) || this.grid.canVisit(nextTry = current.getWest()))) {
            nextTry = null;
        }
        return nextTry;
    }

    protected void removeLastOnStackDisplay() {
        String text = this.stackDisplay.getText();
        int newLast = text.lastIndexOf(10);
        this.stackDisplay.setText(text.substring(0, newLast));
    }

    public void setSpeed(int speed) {
        this.sleepTime = 1000 / speed;
    }
}

