/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import objectdraw.DrawingCanvas;
import objectdraw.FilledRect;
import objectdraw.FramedRect;

public class MazeGrid {
    public static final Color FAILED_COLOR = Color.yellow;
    public static final Color VISITED_COLOR = Color.blue;
    public static final Color WALL_COLOR = Color.black;
    public static final Color OPEN_COLOR = Color.white;
    public static final Color START_COLOR = Color.green;
    public static final Color FINISH_COLOR = Color.red;
    protected int numRows;
    protected int numCols;
    protected double rwidth;
    protected double rheight;
    protected double gleft;
    protected double gtop;
    protected FilledRect[][] colorRect;

    public MazeGrid(double left, double top, int rows, int cols, double width, double height, DrawingCanvas canvas) {
        canvas.clear();
        this.rwidth = width;
        this.rheight = height;
        this.gleft = left;
        this.gtop = top;
        this.numRows = rows;
        this.numCols = cols;
        this.colorRect = new FilledRect[this.numRows][this.numCols];
        int rowNum = 0;
        while (rowNum < this.numRows) {
            int colNum = 0;
            while (colNum < this.numCols) {
                this.colorRect[rowNum][colNum] = new FilledRect(left + (double)colNum * width, top + (double)rowNum * height, width, height, canvas);
                this.colorRect[rowNum][colNum].setColor(WALL_COLOR);
                new FramedRect(left + (double)colNum * width, top + (double)rowNum * height, width, height, canvas);
                ++colNum;
            }
            ++rowNum;
        }
    }

    public void setStart(Position pos) {
        this.colorRect[pos.getRow()][pos.getCol()].setColor(START_COLOR);
    }

    public void setFinish(Position pos) {
        this.colorRect[pos.getRow()][pos.getCol()].setColor(FINISH_COLOR);
    }

    public void setOpen(Position pos) {
        this.colorRect[pos.getRow()][pos.getCol()].setColor(OPEN_COLOR);
    }

    public void visit(Position pos) {
        this.colorRect[pos.getRow()][pos.getCol()].setColor(VISITED_COLOR);
    }

    public void fail(Position pos) {
        this.colorRect[pos.getRow()][pos.getCol()].setColor(FAILED_COLOR);
    }

    public boolean isStart(Position pos) {
        return this.colorRect[pos.getRow()][pos.getCol()].getColor().equals(START_COLOR);
    }

    public boolean isWall(Position pos) {
        return this.colorRect[pos.getRow()][pos.getCol()].getColor().equals(WALL_COLOR);
    }

    public boolean isOpen(Position pos) {
        return this.colorRect[pos.getRow()][pos.getCol()].getColor().equals(OPEN_COLOR);
    }

    public boolean isOnPath(Position pos) {
        return this.colorRect[pos.getRow()][pos.getCol()].getColor().equals(VISITED_COLOR);
    }

    public boolean isFailed(Position pos) {
        return this.colorRect[pos.getRow()][pos.getCol()].getColor().equals(FAILED_COLOR);
    }

    public boolean isFinish(Position pos) {
        return this.colorRect[pos.getRow()][pos.getCol()].getColor().equals(FINISH_COLOR);
    }

    public boolean canVisit(Position pos) {
        int rowNum = pos.getRow();
        int colNum = pos.getCol();
        return rowNum > 0 && rowNum < this.numRows && colNum > 0 && colNum < this.numCols && (this.isOpen(pos) || this.isFinish(pos));
    }
}

