/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.datastructures.Stack;
import objectdraw.WindowController;

public class GraphicsMaze
extends WindowController {
    protected static final int HGAP = 10;
    protected static final int VGAP = 20;
    protected static final int HEIGHT = 25;
    protected static final int WIDTH = 20;
    protected static final int TOP = 100;
    protected static final int LEFT = 30;
    protected static final int HSPACE = 2;
    protected static final int VSPACE = 2;
    protected static final int NUM_MAZES = 4;
    protected static final int SLOW_SPEED = 1;
    protected static final int FAST_SPEED = 10;
    protected int numRows;
    protected int numCols;
    protected Position start;
    protected Position finish;
    protected Position current;
    protected Stack path;
    protected MazeGrid grid;
    protected JButton startButton;
    protected JButton clearMaze;
    protected JComboBox mazeChoice;
    protected JSlider speedSlider;
    protected JTextArea stackDisplay;
    protected MazeValues minput;
    protected boolean success;
    protected MazeSolverInterface mazeThread;

    public void begin() {
        this.minput = new MazeValues();
        this.startButton = new JButton("Solve maze");
        this.startButton.setBackground(MazeGrid.START_COLOR);
        this.startButton.addActionListener(new StartListener(this));
        ClearAndChooseListener clChooseListener = new ClearAndChooseListener();
        this.clearMaze = new JButton("Clear maze");
        this.clearMaze.setBackground(MazeGrid.FINISH_COLOR);
        this.clearMaze.addActionListener(clChooseListener);
        this.mazeChoice = new JComboBox();
        int item = 0;
        while (item < 4) {
            this.mazeChoice.addItem("Maze " + item);
            ++item;
        }
        this.mazeChoice.addActionListener(clChooseListener);
        JPanel bottomPanel = new JPanel(new GridLayout(2, 1));
        this.speedSlider = new JSlider(0, 1, 10, 1);
        this.speedSlider.addChangeListener(new SpeedListener());
        JLabel speedLabel = new JLabel("Adjust speed", 4);
        JPanel speedPanel = new JPanel(new GridLayout(1, 2));
        speedPanel.add(speedLabel);
        speedPanel.add(this.speedSlider);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3, 10, 20));
        buttonPanel.add(this.startButton);
        buttonPanel.add(this.mazeChoice);
        buttonPanel.add(this.clearMaze);
        bottomPanel.add(speedPanel);
        bottomPanel.add(buttonPanel);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)bottomPanel, "South");
        this.stackDisplay = new JTextArea(40, 10);
        this.stackDisplay.setEditable(false);
        this.stackDisplay.setText("Path contents:\n");
        JScrollPane scrollableDisplay = new JScrollPane(this.stackDisplay);
        contentPane.add((Component)scrollableDisplay, "West");
        JLabel title = new JLabel("CS 51 MAZE SOLVER\n\n", 0);
        title.setFont(new Font("myLabel", 2, 36));
        contentPane.add((Component)title, "North");
        this.loadGrid(0);
        if (this.success) {
            this.showStatus("setting up grid");
        } else {
            this.showStatus("Error - maze load failed");
        }
    }

    public void loadGrid(int selection) {
        String[] input = this.minput.getInput(selection);
        this.numRows = this.minput.getNumRows();
        this.numCols = this.minput.getNumCols();
        this.showStatus("Loading grid");
        this.grid = new MazeGrid(30.0, 100.0, this.numRows, this.numCols, 20.0, 25.0, this.canvas);
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                char c = input[row].charAt(col);
                switch (c) {
                    case 's': {
                        this.start = new Position(row, col);
                        this.grid.setStart(this.start);
                        break;
                    }
                    case 'f': {
                        this.finish = new Position(row, col);
                        this.grid.setFinish(this.finish);
                        break;
                    }
                    case ' ': {
                        this.grid.setOpen(new Position(row, col));
                    }
                }
                ++col;
            }
            ++row;
        }
        this.success = this.start != null && this.finish != null;
        this.showStatus("Grid loaded");
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numCols) {
                Position posn = new Position(row, col);
                if (this.grid.isStart(posn)) {
                    s.append('s');
                } else if (this.grid.isFinish(posn)) {
                    s.append('f');
                } else if (this.grid.isOpen(posn)) {
                    s.append(' ');
                } else if (this.grid.isOnPath(posn)) {
                    s.append('p');
                } else if (this.grid.isFailed(posn)) {
                    s.append('f');
                } else if (this.grid.isWall(posn)) {
                    s.append('#');
                } else {
                    s.append('e');
                }
                ++col;
            }
            s.append('\n');
            ++row;
        }
        return s.toString();
    }

    public class StartListener
    implements ActionListener {
        protected GraphicsMaze gMaze;

        public StartListener(GraphicsMaze gMaze) {
            this.gMaze = gMaze;
        }

        public void actionPerformed(ActionEvent e) {
            if (GraphicsMaze.this.success) {
                this.gMaze.showStatus("Running maze");
                GraphicsMaze.this.mazeThread = new MazeSolver(this.gMaze, GraphicsMaze.this.grid, GraphicsMaze.this.start, GraphicsMaze.this.finish, GraphicsMaze.this.speedSlider.getValue(), GraphicsMaze.this.stackDisplay);
                GraphicsMaze.this.mazeThread.start();
            }
        }
    }

    public class ClearAndChooseListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (GraphicsMaze.this.mazeThread != null) {
                GraphicsMaze.this.mazeThread.stopRunning();
            }
            GraphicsMaze.this.loadGrid(GraphicsMaze.this.mazeChoice.getSelectedIndex());
            if (!GraphicsMaze.this.success) {
                GraphicsMaze.this.showStatus("Error - maze load failed");
            }
            GraphicsMaze.this.stackDisplay.setText("Path contents:\n");
        }
    }

    public class SpeedListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            if (GraphicsMaze.this.mazeThread != null) {
                GraphicsMaze.this.mazeThread.setSpeed(GraphicsMaze.this.speedSlider.getValue());
            }
        }
    }
}

