/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.PriorityQueue;
import structure.Vector;

public class VectorHeap
implements PriorityQueue {
    protected Vector data;

    public VectorHeap() {
        this.data = new Vector();
    }

    public VectorHeap(Vector vector) {
        this.data = new Vector(vector.size());
        int n = 0;
        while (n < vector.size()) {
            this.add((Comparable)vector.get(n));
            ++n;
        }
    }

    protected static int parent(int n) {
        return (n - 1) / 2;
    }

    protected static int left(int n) {
        return 2 * n + 1;
    }

    protected static int right(int n) {
        return 2 * (n + 1);
    }

    public Comparable getFirst() {
        return (Comparable)this.data.get(0);
    }

    public Comparable remove() {
        Comparable comparable = this.getFirst();
        this.data.set(0, this.data.get(this.data.size() - 1));
        this.data.setSize(this.data.size() - 1);
        if (this.data.size() > 1) {
            this.pushDownRoot(0);
        }
        return comparable;
    }

    public void add(Comparable comparable) {
        this.data.add(comparable);
        this.percolateUp(this.data.size() - 1);
    }

    public boolean isEmpty() {
        return this.data.size() == 0;
    }

    protected void percolateUp(int n) {
        int n2 = VectorHeap.parent(n);
        Comparable comparable = (Comparable)this.data.get(n);
        while (n > 0 && comparable.compareTo((Comparable)this.data.get(n2)) < 0) {
            this.data.set(n, this.data.get(n2));
            n = n2;
            n2 = VectorHeap.parent(n);
        }
        this.data.set(n, comparable);
    }

    protected void pushDownRoot(int n) {
        int n2 = this.data.size();
        Comparable comparable = (Comparable)this.data.get(n);
        while (n < n2) {
            int n3 = VectorHeap.left(n);
            if (n3 < n2) {
                if (VectorHeap.right(n) < n2 && ((Comparable)this.data.get(n3 + 1)).compareTo((Comparable)this.data.get(n3)) < 0) {
                    ++n3;
                }
                if (((Comparable)this.data.get(n3)).compareTo(comparable) < 0) {
                    this.data.set(n, this.data.get(n3));
                    n = n3;
                    continue;
                }
                this.data.set(n, comparable);
                return;
            }
            this.data.set(n, comparable);
            return;
        }
    }

    public int size() {
        return this.data.size();
    }

    public void clear() {
        this.data.clear();
    }

    public String toString() {
        return "<VectorHeap: " + this.data + ">";
    }
}

