/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Collection;
import java.util.Iterator;
import structure.AbstractList;
import structure.Assert;
import structure.VectorIterator;

public class Vector
extends AbstractList
implements Cloneable {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    protected Object initialValue;
    protected static final int defaultCapacity = 10;

    public Vector() {
        this(10);
    }

    public Vector(int n) {
        Assert.pre(n >= 0, "Nonnegative capacity.");
        this.elementData = new Object[n];
        this.elementCount = 0;
        this.capacityIncrement = 0;
        this.initialValue = null;
    }

    public Vector(int n, int n2) {
        Assert.pre(n >= 0, "Nonnegative capacity.");
        this.elementData = new Object[n];
        this.elementCount = 0;
        this.capacityIncrement = n2;
        this.initialValue = null;
    }

    public Vector(int n, int n2, Object object) {
        Assert.pre(n >= 0, "Nonnegative capacity.");
        this.capacityIncrement = n2;
        this.elementData = new Object[n];
        this.elementCount = 0;
        this.initialValue = object;
    }

    public Vector(Vector vector) {
        this(vector.values());
    }

    public Vector(Collection collection) {
        this(collection.size());
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.set(n++, iterator.next());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void ensureCapacity(int var1_1) {
        block4: {
            block5: {
                if (this.elementData.length >= var1_1) break block4;
                var2_2 = this.elementData.length;
                if (this.capacityIncrement != 0) ** GOTO lbl11
                if (var2_2 == 0) {
                    var2_2 = 1;
                }
                while (var2_2 < var1_1) {
                    var2_2 *= 2;
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    var2_2 += this.capacityIncrement;
lbl11:
                    // 2 sources

                    ** while (var2_2 < var1_1)
                }
            }
            var3_3 = new Object[var2_2];
            var4_4 = 0;
            while (var4_4 < this.elementCount) {
                var3_3[var4_4] = this.elementData[var4_4];
                ++var4_4;
            }
            this.elementData = var3_3;
        }
    }

    public void add(Object object) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount] = object;
        ++this.elementCount;
    }

    public void addElement(Object object) {
        this.add(object);
    }

    public Object remove(Object object) {
        Object object2 = null;
        int n = this.indexOf(object);
        if (n >= 0) {
            object2 = this.get(n);
            this.remove(n);
        }
        return object2;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public Object clone() {
        Vector vector = null;
        try {
            vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.fail("Vector cannot be cloned.");
        }
        return vector;
    }

    public boolean contains(Object object) {
        int n = 0;
        while (n < this.elementCount) {
            if (object.equals(this.elementData[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void copyInto(Object[] objectArray) {
        int n = 0;
        while (n < this.elementCount) {
            objectArray[n] = this.elementData[n];
            ++n;
        }
    }

    public Object elementAt(int n) {
        return this.get(n);
    }

    public Object get(int n) {
        return this.elementData[n];
    }

    public Iterator iterator() {
        return new VectorIterator(this);
    }

    public Object firstElement() {
        return this.get(0);
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(Object object, int n) {
        int n2 = n;
        while (n2 < this.elementCount) {
            if (object.equals(this.elementData[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void insertElementAt(Object object, int n) {
        this.add(n, object);
    }

    public void add(int n, Object object) {
        this.ensureCapacity(this.elementCount + 1);
        int n2 = this.elementCount;
        while (n2 > n) {
            this.elementData[n2] = this.elementData[n2 - 1];
            --n2;
        }
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object lastElement() {
        return this.get(this.elementCount - 1);
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public int lastIndexOf(Object object, int n) {
        int n2 = n;
        while (n2 >= 0) {
            if (object.equals(this.elementData[n2])) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public void clear() {
        this.setSize(0);
    }

    public void removeAllElements() {
        this.setSize(0);
    }

    public void removeElementAt(int n) {
        this.remove(n);
    }

    public Object remove(int n) {
        Object object = this.get(n);
        --this.elementCount;
        while (n < this.elementCount) {
            this.elementData[n] = this.elementData[n + 1];
            ++n;
        }
        this.elementData[this.elementCount] = null;
        return object;
    }

    public void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public Object set(int n, Object object) {
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    public void setSize(int n) {
        if (n < this.elementCount) {
            int n2 = n;
            while (n2 < this.elementCount) {
                this.elementData[n2] = null;
                ++n2;
            }
        } else {
            int n3 = this.elementCount;
            while (n3 < n) {
                this.elementData[n3] = this.initialValue;
                ++n3;
            }
        }
        this.elementCount = n;
    }

    public int size() {
        return this.elementCount;
    }

    public void trimToSize() {
        Object[] objectArray = new Object[this.elementCount];
        this.copyInto(objectArray);
        this.elementData = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Vector:");
        int n = 0;
        while (n < this.size()) {
            stringBuffer.append(" " + this.get(n));
            ++n;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

