/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import java.util.Map;
import structure.AbstractMap;
import structure.ComparableAssociation;
import structure.KeyIterator;
import structure.OrderedMap;
import structure.OrderedStructure;
import structure.ReadStream;
import structure.Set;
import structure.SetList;
import structure.SinglyLinkedList;
import structure.SplayTree;
import structure.Structure;
import structure.ValueIterator;

public class Table
extends AbstractMap
implements OrderedMap {
    protected OrderedStructure data = new SplayTree();

    public Table() {
    }

    public Table(Table table) {
        Iterator iterator = table.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object get(Object object) {
        ComparableAssociation comparableAssociation = new ComparableAssociation((Comparable)object, null);
        ComparableAssociation comparableAssociation2 = (ComparableAssociation)this.data.remove(comparableAssociation);
        if (comparableAssociation2 == null) {
            return null;
        }
        this.data.add(comparableAssociation2);
        return comparableAssociation2.getValue();
    }

    public Object put(Object object, Object object2) {
        ComparableAssociation comparableAssociation = new ComparableAssociation((Comparable)object, object2);
        ComparableAssociation comparableAssociation2 = (ComparableAssociation)this.data.remove(comparableAssociation);
        this.data.add(comparableAssociation);
        if (comparableAssociation2 == null) {
            return null;
        }
        return comparableAssociation2.getValue();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void clear() {
        this.data.clear();
    }

    public Iterator keys() {
        return new KeyIterator(this.data.iterator());
    }

    public Iterator iterator() {
        return new ValueIterator(this.data.iterator());
    }

    public boolean containsKey(Object object) {
        ComparableAssociation comparableAssociation = new ComparableAssociation((Comparable)object, null);
        return this.data.contains(comparableAssociation);
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null || !e.equals(object)) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object object) {
        ComparableAssociation comparableAssociation = new ComparableAssociation((Comparable)object, null);
        if ((comparableAssociation = (ComparableAssociation)this.data.remove(comparableAssociation)) == null) {
            return null;
        }
        return comparableAssociation.getValue();
    }

    public int size() {
        return this.data.size();
    }

    public Set keySet() {
        SetList setList = new SetList();
        KeyIterator keyIterator = new KeyIterator(this.data.iterator());
        while (keyIterator.hasNext()) {
            setList.add(keyIterator.next());
        }
        return setList;
    }

    public Structure values() {
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        ValueIterator valueIterator = new ValueIterator(this.data.iterator());
        while (valueIterator.hasNext()) {
            singlyLinkedList.add(valueIterator.next());
        }
        return singlyLinkedList;
    }

    public Set entrySet() {
        SetList setList = new SetList();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            setList.add(iterator.next());
        }
        return setList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Table: size=" + this.size());
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            ComparableAssociation comparableAssociation = (ComparableAssociation)iterator.next();
            stringBuffer.append(" key=" + comparableAssociation.getKey() + ", value=" + comparableAssociation.getValue());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Table table = new Table();
        ReadStream readStream = new ReadStream();
        System.out.println("Enter a word: ");
        while (!readStream.eof()) {
            String string = readStream.readLine();
            System.out.println("Enter a definition: ");
            String string2 = readStream.readLine();
            table.put(string, string2);
            System.out.println("Enter a word: ");
        }
        System.out.println(table);
    }
}

