/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import structure.Assert;
import structure.Structure;

public class StructCollection
implements Collection {
    protected Structure base;

    public StructCollection(Structure structure) {
        this.base = structure;
    }

    public boolean add(Object object) {
        this.base.add(object);
        return true;
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    public void clear() {
        this.base.clear();
    }

    public boolean contains(Object object) {
        return this.base.contains(object);
    }

    public boolean containsAll(Collection collection) {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (bl && iterator.hasNext()) {
            bl &= this.contains(iterator.next());
        }
        return bl;
    }

    public boolean equals(Object object) {
        return this.base.equals(object);
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    public Iterator iterator() {
        return this.base.iterator();
    }

    public boolean remove(Object object) {
        Object object2 = this.base.remove(object);
        return object2 != null;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl &= this.remove(iterator.next());
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        Vector vector = new Vector();
        Iterator iterator = this.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e)) {
                vector.addElement(e);
                continue;
            }
            bl = true;
        }
        if (bl) {
            this.clear();
            this.addAll((Collection)vector);
        }
        return bl;
    }

    public int size() {
        return this.base.size();
    }

    public Object[] toArray() {
        int n = this.size();
        Object[] objectArray = new Object[n];
        return this.toArray(objectArray);
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (n > objectArray.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext() && n2 < n) {
            objectArray[n2++] = iterator.next();
        }
        Assert.pre(!iterator.hasNext(), "Collection size() consistent with iterator.");
        if (n2 < n) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    public String toString() {
        return "<StructCollection wrapping " + this.base + ">";
    }
}

