/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractStack;
import structure.ArrayIterator;
import structure.Assert;
import structure.Stack;

public class StackArray
extends AbstractStack
implements Stack {
    protected int top;
    protected Object[] data;

    public StackArray(int n) {
        this.data = new Object[n];
        this.clear();
    }

    public void clear() {
        this.top = -1;
    }

    public void add(Object object) {
        Assert.pre(!this.isFull(), "Stack is not full.");
        ++this.top;
        this.data[this.top] = object;
    }

    public Object remove() {
        Assert.pre(!this.isEmpty(), "Stack is not empty.");
        Object object = this.data[this.top];
        this.data[this.top] = null;
        --this.top;
        return object;
    }

    public Object get() {
        Assert.pre(!this.isEmpty(), "Stack is not empty.");
        return this.data[this.top];
    }

    public Iterator iterator() {
        return new ArrayIterator(this.data, 0, this.size());
    }

    public int size() {
        return this.top + 1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.top == this.data.length - 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<StackArray: ");
        int n = this.top;
        while (n >= 0) {
            stringBuffer.append(" " + this.data[n]);
            --n;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

