/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.AbstractIterator;
import structure.BinaryTree;

class SplayTreeIterator
extends AbstractIterator {
    protected BinaryTree tree;
    protected BinaryTree current;

    public SplayTreeIterator(BinaryTree binaryTree) {
        this.tree = binaryTree;
        this.reset();
    }

    public void reset() {
        this.current = this.tree;
        if (!this.current.isEmpty()) {
            this.current = this.current.root();
            while (!this.current.left().isEmpty()) {
                this.current = this.current.left();
            }
        }
    }

    public boolean hasNext() {
        return !this.current.isEmpty();
    }

    public Object next() {
        Object object = this.current.value();
        if (!this.current.right().isEmpty()) {
            this.current = this.current.right();
            while (!this.current.left().isEmpty()) {
                this.current = this.current.left();
            }
        } else {
            boolean bl;
            do {
                bl = this.current.isLeftChild();
                this.current = this.current.parent();
            } while (this.current != null && !bl);
            if (this.current == null) {
                this.current = BinaryTree.EMPTY;
            }
        }
        return object;
    }

    public Object get() {
        return this.current.value();
    }
}

