/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Comparator;
import java.util.Iterator;
import structure.BinarySearchTree;
import structure.BinaryTree;
import structure.NaturalComparator;
import structure.OrderedStructure;
import structure.SplayTreeIterator;

public class SplayTree
extends BinarySearchTree
implements OrderedStructure {
    public SplayTree() {
        this(new NaturalComparator());
    }

    public SplayTree(Comparator comparator) {
        super(comparator);
    }

    public void add(Object object) {
        BinaryTree binaryTree = new BinaryTree(object);
        if (this.root.isEmpty()) {
            this.root = binaryTree;
        } else {
            BinaryTree binaryTree2 = this.locate(this.root, object);
            Object object2 = binaryTree2.value();
            if (this.ordering.compare(object2, object) < 0) {
                binaryTree2.setRight(binaryTree);
            } else if (!binaryTree2.left().isEmpty()) {
                this.predecessor(binaryTree2).setRight(binaryTree);
            } else {
                binaryTree2.setLeft(binaryTree);
            }
            this.root = binaryTree;
            this.splay(this.root);
        }
        ++this.count;
    }

    public boolean contains(Object object) {
        if (this.root.isEmpty()) {
            return false;
        }
        BinaryTree binaryTree = this.locate(this.root, object);
        if (object.equals(binaryTree.value())) {
            this.root = binaryTree;
            this.splay(this.root);
            return true;
        }
        return false;
    }

    public Object get(Object object) {
        BinaryTree binaryTree;
        if (this.root.isEmpty()) {
            return null;
        }
        this.root = binaryTree = this.locate(this.root, object);
        this.splay(this.root);
        if (object.equals(binaryTree.value())) {
            return binaryTree.value();
        }
        return null;
    }

    public Object remove(Object object) {
        if (this.isEmpty()) {
            return null;
        }
        if (object.equals(this.root.value())) {
            BinaryTree binaryTree = this.removeTop(this.root);
            --this.count;
            Object object2 = this.root.value();
            this.root = binaryTree;
            return object2;
        }
        BinaryTree binaryTree = this.locate(this.root, object);
        if (object.equals(binaryTree.value())) {
            --this.count;
            BinaryTree binaryTree2 = binaryTree.parent();
            if (binaryTree2.right() == binaryTree) {
                binaryTree2.setRight(this.removeTop(binaryTree));
            } else {
                binaryTree2.setLeft(this.removeTop(binaryTree));
            }
            this.root = binaryTree2;
            this.splay(this.root);
            return binaryTree.value();
        }
        return null;
    }

    protected void splay(BinaryTree binaryTree) {
        BinaryTree binaryTree2;
        while ((binaryTree2 = binaryTree.parent()) != null) {
            BinaryTree binaryTree3 = binaryTree2.parent();
            if (binaryTree3 == null) {
                if (binaryTree.isLeftChild()) {
                    binaryTree2.rotateRight();
                    continue;
                }
                binaryTree2.rotateLeft();
                continue;
            }
            if (binaryTree2.isLeftChild()) {
                if (binaryTree.isLeftChild()) {
                    binaryTree3.rotateRight();
                    binaryTree2.rotateRight();
                    continue;
                }
                binaryTree2.rotateLeft();
                binaryTree3.rotateRight();
                continue;
            }
            if (binaryTree.isRightChild()) {
                binaryTree3.rotateLeft();
                binaryTree2.rotateLeft();
                continue;
            }
            binaryTree2.rotateRight();
            binaryTree3.rotateLeft();
        }
    }

    public Iterator iterator() {
        return new SplayTreeIterator(this.root);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SplayTree: size=" + this.count + " root=" + this.root + ">");
        return stringBuffer.toString();
    }
}

