/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import java.util.Random;
import structure.Assert;
import structure.BinaryTree;
import structure.MergeableHeap;
import structure.PriorityQueue;

public class SkewHeap
implements PriorityQueue,
MergeableHeap {
    protected BinaryTree root = BinaryTree.EMPTY;
    protected int count = 0;

    public Comparable getFirst() {
        return (Comparable)this.root.value();
    }

    public Comparable remove() {
        Comparable comparable = (Comparable)this.root.value();
        this.root = SkewHeap.merge(this.root.left(), this.root.right());
        --this.count;
        return comparable;
    }

    public void add(Comparable comparable) {
        BinaryTree binaryTree = new BinaryTree(comparable);
        this.root = SkewHeap.merge(binaryTree, this.root);
        ++this.count;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.root = BinaryTree.EMPTY;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void merge(MergeableHeap mergeableHeap) {
        Assert.pre(mergeableHeap instanceof SkewHeap, "otherHeap must be instance of SkewHeap");
        SkewHeap skewHeap = (SkewHeap)mergeableHeap;
        this.root = SkewHeap.merge(this.root, skewHeap.root);
        skewHeap.root = null;
        this.count += skewHeap.count;
    }

    protected static BinaryTree merge(BinaryTree binaryTree, BinaryTree binaryTree2) {
        BinaryTree binaryTree3;
        if (binaryTree.isEmpty()) {
            return binaryTree2;
        }
        if (binaryTree2.isEmpty()) {
            return binaryTree;
        }
        Comparable comparable = (Comparable)binaryTree.value();
        Comparable comparable2 = (Comparable)binaryTree2.value();
        if (comparable2.compareTo(comparable) < 0) {
            binaryTree3 = SkewHeap.merge(binaryTree2, binaryTree);
        } else {
            binaryTree3 = binaryTree;
            if (binaryTree3.left().isEmpty()) {
                binaryTree3.setLeft(binaryTree2);
            } else {
                BinaryTree binaryTree4 = binaryTree3.right();
                binaryTree3.setRight(binaryTree3.left());
                binaryTree3.setLeft(SkewHeap.merge(binaryTree4, binaryTree2));
            }
        }
        return binaryTree3;
    }

    public String toString() {
        if (this.root.isEmpty()) {
            return "<SkewHeap: >";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SkewHeap:");
        if (!this.root.isEmpty()) {
            Iterator iterator = this.root.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(" " + iterator.next());
            }
        }
        return stringBuffer + ">";
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        try {
            while (n3 != 198) {
                Random random = new Random();
                n4 = 0;
                n = 0;
                n2 = 0;
                n3 = 0;
                SkewHeap skewHeap = new SkewHeap();
                SkewHeap skewHeap2 = new SkewHeap();
                n4 = random.nextInt(100);
                int n5 = 0;
                while (n5 < n4) {
                    skewHeap.add(new Integer(random.nextInt(1000)));
                    ++n5;
                }
                n4 = random.nextInt(100);
                int n6 = 0;
                while (n6 < n4) {
                    skewHeap2.add(new Integer(random.nextInt(1000)));
                    ++n6;
                }
                n = skewHeap.size();
                n2 = skewHeap2.size();
                skewHeap.merge(skewHeap2);
                n3 = skewHeap.size();
                System.out.println(n + " : " + n2 + " : " + n3);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println(n + " : " + n2 + " : " + n3);
        }
    }
}

