/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Enumeration;
import java.util.Iterator;
import structure.AbstractList;
import structure.Assert;
import structure.SinglyLinkedListElement;
import structure.SinglyLinkedListIterator;

public class SinglyLinkedList
extends AbstractList {
    protected int count = 0;
    protected SinglyLinkedListElement head = null;

    public void add(Object object) {
        this.addLast(object);
    }

    public void addFirst(Object object) {
        this.head = new SinglyLinkedListElement(object, this.head);
        ++this.count;
    }

    public Object removeFirst() {
        SinglyLinkedListElement singlyLinkedListElement = this.head;
        this.head = this.head.next();
        --this.count;
        return singlyLinkedListElement.value();
    }

    public void addLast(Object object) {
        SinglyLinkedListElement singlyLinkedListElement = new SinglyLinkedListElement(object, null);
        if (this.head != null) {
            SinglyLinkedListElement singlyLinkedListElement2 = this.head;
            while (singlyLinkedListElement2.next() != null) {
                singlyLinkedListElement2 = singlyLinkedListElement2.next();
            }
            singlyLinkedListElement2.setNext(singlyLinkedListElement);
        } else {
            this.head = singlyLinkedListElement;
        }
        ++this.count;
    }

    public Object removeLast() {
        SinglyLinkedListElement singlyLinkedListElement = this.head;
        SinglyLinkedListElement singlyLinkedListElement2 = null;
        Assert.pre(this.head != null, "List is not empty.");
        while (singlyLinkedListElement.next() != null) {
            singlyLinkedListElement2 = singlyLinkedListElement;
            singlyLinkedListElement = singlyLinkedListElement.next();
        }
        if (singlyLinkedListElement2 == null) {
            this.head = null;
        } else {
            singlyLinkedListElement2.setNext(null);
        }
        --this.count;
        return singlyLinkedListElement.value();
    }

    public Object getFirst() {
        return this.head.value();
    }

    public Object getLast() {
        SinglyLinkedListElement singlyLinkedListElement = this.head;
        Assert.condition(singlyLinkedListElement != null, "List is not empty.");
        while (singlyLinkedListElement != null && singlyLinkedListElement.next() != null) {
            singlyLinkedListElement = singlyLinkedListElement.next();
        }
        return singlyLinkedListElement.value();
    }

    public boolean contains(Object object) {
        SinglyLinkedListElement singlyLinkedListElement = this.head;
        while (singlyLinkedListElement != null && !singlyLinkedListElement.value().equals(object)) {
            singlyLinkedListElement = singlyLinkedListElement.next();
        }
        return singlyLinkedListElement != null;
    }

    public Object remove(Object object) {
        SinglyLinkedListElement singlyLinkedListElement = this.head;
        SinglyLinkedListElement singlyLinkedListElement2 = null;
        while (singlyLinkedListElement != null && !singlyLinkedListElement.value().equals(object)) {
            singlyLinkedListElement2 = singlyLinkedListElement;
            singlyLinkedListElement = singlyLinkedListElement.next();
        }
        if (singlyLinkedListElement != null) {
            if (singlyLinkedListElement2 == null) {
                this.head = singlyLinkedListElement.next();
            } else {
                singlyLinkedListElement2.setNext(singlyLinkedListElement.next());
            }
            --this.count;
            return singlyLinkedListElement.value();
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.head = null;
        this.count = 0;
    }

    public Object get(int n) {
        if (n >= this.size()) {
            return null;
        }
        SinglyLinkedListElement singlyLinkedListElement = this.head;
        while (n > 0) {
            singlyLinkedListElement = singlyLinkedListElement.next();
            --n;
        }
        return singlyLinkedListElement.value();
    }

    public Object set(int n, Object object) {
        if (n >= this.size()) {
            return null;
        }
        SinglyLinkedListElement singlyLinkedListElement = this.head;
        while (n > 0) {
            singlyLinkedListElement = singlyLinkedListElement.next();
            --n;
        }
        Object object2 = singlyLinkedListElement.value();
        singlyLinkedListElement.setValue(object);
        return object2;
    }

    public void add(int n, Object object) {
        Assert.pre(0 <= n && n <= this.size(), "Index in range.");
        if (n == this.size()) {
            this.addLast(object);
        } else if (n == 0) {
            this.addFirst(object);
        } else {
            SinglyLinkedListElement singlyLinkedListElement = null;
            SinglyLinkedListElement singlyLinkedListElement2 = this.head;
            while (n > 0) {
                singlyLinkedListElement = singlyLinkedListElement2;
                singlyLinkedListElement2 = singlyLinkedListElement2.next();
                --n;
            }
            SinglyLinkedListElement singlyLinkedListElement3 = new SinglyLinkedListElement(object, singlyLinkedListElement2);
            ++this.count;
            singlyLinkedListElement.setNext(singlyLinkedListElement3);
        }
    }

    public Object remove(int n) {
        Assert.pre(0 <= n && n < this.size(), "Index in range.");
        if (n == 0) {
            return this.removeFirst();
        }
        if (n == this.size() - 1) {
            return this.removeLast();
        }
        SinglyLinkedListElement singlyLinkedListElement = null;
        SinglyLinkedListElement singlyLinkedListElement2 = this.head;
        while (n > 0) {
            singlyLinkedListElement = singlyLinkedListElement2;
            singlyLinkedListElement2 = singlyLinkedListElement2.next();
            --n;
        }
        singlyLinkedListElement.setNext(singlyLinkedListElement2.next());
        --this.count;
        return singlyLinkedListElement2.value();
    }

    public int indexOf(Object object) {
        int n = 0;
        SinglyLinkedListElement singlyLinkedListElement = this.head;
        while (singlyLinkedListElement != null && !singlyLinkedListElement.value().equals(object)) {
            singlyLinkedListElement = singlyLinkedListElement.next();
            ++n;
        }
        if (singlyLinkedListElement == null) {
            return -1;
        }
        return n;
    }

    public int lastIndexOf(Object object) {
        int n = -1;
        int n2 = 0;
        SinglyLinkedListElement singlyLinkedListElement = this.head;
        while (singlyLinkedListElement != null) {
            if (singlyLinkedListElement.value().equals(object)) {
                n = n2;
            }
            singlyLinkedListElement = singlyLinkedListElement.next();
            ++n2;
        }
        return n;
    }

    public Iterator iterator() {
        return new SinglyLinkedListIterator(this.head);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SinglyLinkedList:");
        Enumeration enumeration = (Enumeration)((Object)this.iterator());
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(" " + enumeration.nextElement());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

