/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.Assert;
import structure.RedBlackIterator;

public class RedBlackTree {
    protected RedBlackTree left;
    protected RedBlackTree right;
    protected RedBlackTree parent;
    protected Comparable value;
    protected boolean isRed;
    public static final RedBlackTree EMPTY = new RedBlackTree();

    protected RedBlackTree() {
        this.value = null;
        this.parent = null;
        this.left = this.right = this;
        this.isRed = false;
    }

    public RedBlackTree(Comparable comparable) {
        this.value = comparable;
        this.parent = null;
        this.left = this.right = EMPTY;
        this.isRed = false;
    }

    protected boolean isRed() {
        return this.isRed;
    }

    protected boolean isBlack() {
        return !this.isRed;
    }

    protected void setRed() {
        this.isRed = true;
    }

    protected void setRed(boolean bl) {
        this.isRed = bl;
    }

    protected void setBlack() {
        this.isRed = false;
    }

    protected Object value() {
        return this.value;
    }

    protected RedBlackTree left() {
        return this.left;
    }

    protected RedBlackTree right() {
        return this.right;
    }

    protected RedBlackTree parent() {
        return this.parent;
    }

    protected void setParent(RedBlackTree redBlackTree) {
        this.parent = redBlackTree;
    }

    protected void setLeft(RedBlackTree redBlackTree) {
        if (this.isEmpty()) {
            return;
        }
        if (this.left.parent() == this) {
            this.left.setParent(null);
        }
        this.left = redBlackTree;
        this.left.setParent(this);
    }

    protected void setRight(RedBlackTree redBlackTree) {
        if (this.isEmpty()) {
            return;
        }
        if (this.right.parent() == this) {
            this.right.setParent(null);
        }
        this.right = redBlackTree;
        this.right.setParent(this);
    }

    public boolean isLeftChild() {
        if (this.parent() == null) {
            return false;
        }
        return this == this.parent().left();
    }

    public boolean isRightChild() {
        if (this.parent() == null) {
            return false;
        }
        return this == this.parent().right();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    protected boolean isRoot() {
        return this.parent == null;
    }

    protected RedBlackTree root() {
        RedBlackTree redBlackTree = this;
        while (!redBlackTree.isRoot()) {
            redBlackTree = redBlackTree.parent();
        }
        return redBlackTree;
    }

    public int depth() {
        if (this.parent() == null) {
            return 0;
        }
        return 1 + this.parent.depth();
    }

    protected void rotateRight() {
        RedBlackTree redBlackTree = this.parent();
        RedBlackTree redBlackTree2 = this.left();
        boolean bl = !this.isRoot();
        boolean bl2 = this.isLeftChild();
        this.setLeft(redBlackTree2.right());
        redBlackTree2.setRight(this);
        if (bl) {
            if (bl2) {
                redBlackTree.setLeft(redBlackTree2);
            } else {
                redBlackTree.setRight(redBlackTree2);
            }
        } else {
            Assert.post(redBlackTree2.isRoot(), "Rotate at root preserves root.");
        }
    }

    protected void rotateLeft() {
        RedBlackTree redBlackTree = this.parent();
        RedBlackTree redBlackTree2 = this.right();
        boolean bl = !this.isRoot();
        boolean bl2 = this.isRightChild();
        this.setRight(redBlackTree2.left());
        redBlackTree2.setLeft(this);
        if (bl) {
            if (bl2) {
                redBlackTree.setRight(redBlackTree2);
            } else {
                redBlackTree.setLeft(redBlackTree2);
            }
        } else {
            Assert.post(redBlackTree2.isRoot(), "Left rotate at root preserves root.");
        }
    }

    public RedBlackTree add(Comparable comparable) {
        RedBlackTree redBlackTree = this.insert(comparable);
        redBlackTree.setRed();
        redBlackTree.redFixup();
        return redBlackTree.root();
    }

    protected RedBlackTree insert(Comparable comparable) {
        if (this.isEmpty()) {
            return new RedBlackTree(comparable);
        }
        if (comparable.compareTo(this.value()) < 0) {
            if (this.left().isEmpty()) {
                RedBlackTree redBlackTree = new RedBlackTree(comparable);
                this.setLeft(redBlackTree);
                return redBlackTree;
            }
            return this.left().insert(comparable);
        }
        if (this.right().isEmpty()) {
            RedBlackTree redBlackTree = new RedBlackTree(comparable);
            this.setRight(redBlackTree);
            return redBlackTree;
        }
        return this.right().insert(comparable);
    }

    public void redFixup() {
        if (this.isRoot() || !this.parent().isRed()) {
            this.root().setBlack();
        } else {
            RedBlackTree redBlackTree = this.parent();
            RedBlackTree redBlackTree2 = redBlackTree.parent();
            if (redBlackTree.isLeftChild()) {
                RedBlackTree redBlackTree3 = redBlackTree2.right();
                if (redBlackTree3.isRed()) {
                    redBlackTree2.setRed();
                    redBlackTree3.setBlack();
                    redBlackTree.setBlack();
                    redBlackTree2.redFixup();
                } else if (this.isRightChild()) {
                    redBlackTree.rotateLeft();
                    redBlackTree.redFixup();
                } else {
                    redBlackTree2.rotateRight();
                    redBlackTree2.setRed();
                    redBlackTree.setBlack();
                }
            } else {
                RedBlackTree redBlackTree4 = redBlackTree2.left();
                if (redBlackTree4.isRed()) {
                    redBlackTree2.setRed();
                    redBlackTree4.setBlack();
                    redBlackTree.setBlack();
                    redBlackTree2.redFixup();
                } else if (this.isLeftChild()) {
                    redBlackTree.rotateRight();
                    redBlackTree.redFixup();
                } else {
                    redBlackTree2.rotateLeft();
                    redBlackTree2.setRed();
                    redBlackTree.setBlack();
                }
            }
        }
    }

    public RedBlackTree remove(Comparable comparable) {
        RedBlackTree redBlackTree;
        RedBlackTree redBlackTree2 = this.locate(comparable);
        if (redBlackTree2.isEmpty()) {
            return this.root();
        }
        if (redBlackTree2.left().isEmpty() || redBlackTree2.right().isEmpty()) {
            redBlackTree = redBlackTree2;
        } else {
            redBlackTree = redBlackTree2.left();
            while (!redBlackTree.right().isEmpty()) {
                redBlackTree = redBlackTree.right();
            }
        }
        redBlackTree2.value = redBlackTree.value;
        RedBlackTree redBlackTree3 = redBlackTree.left().isEmpty() ? redBlackTree.right() : redBlackTree.left();
        redBlackTree3.setParent(redBlackTree.parent());
        if (!redBlackTree.isRoot()) {
            if (redBlackTree.isLeftChild()) {
                redBlackTree.parent().setLeft(redBlackTree3);
            } else {
                redBlackTree.parent().setRight(redBlackTree3);
            }
        }
        RedBlackTree redBlackTree4 = redBlackTree3.root();
        if (redBlackTree.isBlack()) {
            redBlackTree3.blackFixup();
        }
        return redBlackTree4.root();
    }

    protected void blackFixup() {
        if (this.isRoot() || this.isRed()) {
            this.setBlack();
        } else {
            RedBlackTree redBlackTree = this.parent();
            if (this.isLeftChild()) {
                RedBlackTree redBlackTree2 = redBlackTree.right();
                if (redBlackTree2.isRed()) {
                    redBlackTree2.setBlack();
                    redBlackTree.setRed();
                    redBlackTree.rotateLeft();
                    this.blackFixup();
                } else if (redBlackTree2.left().isBlack() && redBlackTree2.right().isBlack()) {
                    redBlackTree2.setRed();
                    redBlackTree.blackFixup();
                } else {
                    if (redBlackTree2.right().isBlack()) {
                        redBlackTree2.left().setBlack();
                        redBlackTree2.setRed();
                        redBlackTree2.rotateRight();
                        redBlackTree2 = redBlackTree.right();
                    }
                    redBlackTree2.setRed(redBlackTree.isRed());
                    redBlackTree.setBlack();
                    redBlackTree2.right().setBlack();
                    redBlackTree.rotateLeft();
                    this.root().blackFixup();
                }
            } else {
                RedBlackTree redBlackTree3 = redBlackTree.left();
                if (redBlackTree3.isRed()) {
                    redBlackTree3.setBlack();
                    redBlackTree.setRed();
                    redBlackTree.rotateRight();
                    this.blackFixup();
                } else if (redBlackTree3.left().isBlack() && redBlackTree3.right().isBlack()) {
                    redBlackTree3.setRed();
                    redBlackTree.blackFixup();
                } else {
                    if (redBlackTree3.left().isBlack()) {
                        redBlackTree3.right().setBlack();
                        redBlackTree3.setRed();
                        redBlackTree3.rotateLeft();
                        redBlackTree3 = redBlackTree.left();
                    }
                    redBlackTree3.setRed(redBlackTree.isRed());
                    redBlackTree.setBlack();
                    redBlackTree3.left().setBlack();
                    redBlackTree.rotateRight();
                    this.root().blackFixup();
                }
            }
        }
    }

    public boolean contains(Comparable comparable) {
        return this.locate(comparable) != null;
    }

    protected RedBlackTree locate(Comparable comparable) {
        if (this.isEmpty()) {
            return null;
        }
        int n = comparable.compareTo(this.value());
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.left().locate(comparable);
        }
        return this.right().locate(comparable);
    }

    public Comparable get(Comparable comparable) {
        RedBlackTree redBlackTree = this.locate(comparable);
        if (redBlackTree == null) {
            return null;
        }
        return (Comparable)redBlackTree.value();
    }

    public boolean consistency() {
        return this.wellConnected(null) && this.redConsistency() && this.blackConsistency();
    }

    protected int blackHeight() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isBlack()) {
            return 1 + this.left().blackHeight();
        }
        return this.left().blackHeight();
    }

    protected boolean redConsistency() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.isRed() && (this.left().isRed() || this.right().isRed())) {
            return false;
        }
        return this.left().redConsistency() && this.right().redConsistency();
    }

    protected boolean blackConsistency() {
        if (!this.isRoot()) {
            Assert.debug("Tree consistency not tested at root.");
            return false;
        }
        if (!this.isBlack()) {
            Assert.debug("Root is not black.");
            return false;
        }
        if (!this.consistentlyBlackHeight(this.blackHeight())) {
            Assert.debug("Black height inconsistent.");
            return false;
        }
        return true;
    }

    protected boolean consistentlyBlackHeight(int n) {
        if (this.isEmpty()) {
            return n == 0;
        }
        if (this.isBlack()) {
            --n;
        }
        return this.left().consistentlyBlackHeight(n) && this.right().consistentlyBlackHeight(n);
    }

    public boolean wellConnected(RedBlackTree redBlackTree) {
        boolean bl = true;
        if (this.isEmpty()) {
            if (this.left != this) {
                bl = false;
                Assert.debug("EMPTY left not self.");
            }
            if (this.right != this) {
                bl = false;
                Assert.debug("EMPTY right not self.");
            }
        } else {
            if (redBlackTree != this.parent()) {
                bl = false;
                Object object = redBlackTree == null ? "null" : redBlackTree.value();
                Object object2 = this.parent == null ? "null" : this.parent.value();
                Assert.debug("Parent of " + this.value() + " was not " + object + ", but " + object2);
            }
            if (this.value == null) {
                bl = false;
                Assert.debug("null value found in tree");
            }
            bl = bl & this.left().wellConnected(this) & this.right().wellConnected(this);
        }
        return bl;
    }

    public void print() {
        if (this.isEmpty()) {
            return;
        }
        this.left().print();
        System.out.println(this.value());
        this.right().print();
    }

    public Iterator iterator() {
        return new RedBlackIterator(this);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = this.left().hashCode() + this.right().hashCode();
        if (this.value() != null) {
            n += this.value().hashCode();
        }
        return n;
    }

    public String treeString() {
        String string = "";
        int n = 0;
        while (n < this.depth()) {
            string = string + "\t|";
            ++n;
        }
        string = string + "<" + this.value() + " : " + this.getHand() + " : " + this.getColor() + ">\n";
        if (this.left != EMPTY) {
            string = string + this.left.treeString();
        }
        if (this.right != EMPTY) {
            string = string + this.right.treeString();
        }
        return string;
    }

    private String getHand() {
        if (this.isRightChild()) {
            return "R";
        }
        if (this.isLeftChild()) {
            return "L";
        }
        return "Root";
    }

    private String getColor() {
        if (this.isRed) {
            return "Red";
        }
        return "Black";
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        if (this.isRed()) {
            return "(" + this.left() + this.value() + this.right() + ")";
        }
        return "[" + this.left() + this.value() + this.right() + "]";
    }
}

