/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractStructure;
import structure.Assert;
import structure.OrderedStructure;
import structure.RedBlackTree;

public class RedBlackSearchTree
extends AbstractStructure
implements OrderedStructure {
    protected RedBlackTree root = RedBlackTree.EMPTY;
    protected int count = 0;

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public void clear() {
        this.root = RedBlackTree.EMPTY;
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public void add(Object object) {
        Assert.pre(object instanceof Comparable, "value must implement Comparable");
        this.root = this.root.add((Comparable)object);
        ++this.count;
    }

    public Object remove(Object object) {
        Assert.pre(object instanceof Comparable, "value must implement Comparable");
        if (this.root.contains((Comparable)object)) {
            this.root = this.root.remove((Comparable)object);
            --this.count;
            return object;
        }
        return null;
    }

    public boolean contains(Object object) {
        Assert.pre(object instanceof Comparable, "value must implement Comparable");
        return this.root.contains((Comparable)object);
    }

    public boolean isRedBlack() {
        return this.root.consistency();
    }

    public Iterator iterator() {
        return this.root.iterator();
    }

    public String treeString() {
        return this.root.treeString();
    }

    public String toString() {
        return this.root.toString();
    }

    public int hashCode() {
        return this.root.hashCode();
    }
}

