/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.AbstractIterator;
import structure.RedBlackTree;
import structure.Stack;
import structure.StackList;

class RedBlackIterator
extends AbstractIterator {
    protected RedBlackTree root;
    protected Stack todo = new StackList();

    public RedBlackIterator(RedBlackTree redBlackTree) {
        this.root = redBlackTree;
        this.reset();
    }

    public void reset() {
        this.todo.clear();
        RedBlackTree redBlackTree = this.root;
        while (redBlackTree != RedBlackTree.EMPTY) {
            this.todo.push(redBlackTree);
            redBlackTree = redBlackTree.left();
        }
    }

    public boolean hasNext() {
        return !this.todo.isEmpty();
    }

    public Object get() {
        return ((RedBlackTree)this.todo.getFirst()).value();
    }

    public Object next() {
        RedBlackTree redBlackTree = (RedBlackTree)this.todo.pop();
        Object object = redBlackTree.value();
        if (!redBlackTree.right().isEmpty()) {
            RedBlackTree redBlackTree2 = redBlackTree.right();
            do {
                this.todo.push(redBlackTree2);
            } while (!(redBlackTree2 = redBlackTree2.left()).isEmpty());
        }
        return object;
    }
}

