/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import structure.Assert;

public class ReadStream
extends FilterInputStream {
    protected DataInputStream strm = (DataInputStream)this.in;
    protected boolean atEOF = false;
    protected char[] buffer = new char[8];
    protected int buffersize = 8;
    protected int buffertop = -1;
    protected boolean absorbNL = false;

    public ReadStream() {
        this(System.in);
    }

    public ReadStream(InputStream inputStream) {
        super(new DataInputStream(inputStream));
    }

    public boolean eof() {
        if (this.atEOF) {
            return true;
        }
        this.getFirst();
        return this.atEOF;
    }

    private static boolean isWhite(char c) {
        return Character.isWhitespace(c);
    }

    public char getFirst() {
        char c = this.readChar();
        this.pushbackChar(c);
        return c;
    }

    public boolean eoln() {
        char c = this.getFirst();
        return this.eof() || c == '\n' || c == '\r';
    }

    public void readln() {
        this.readLine();
    }

    public void skipWhite() {
        char c = this.readChar();
        while (ReadStream.isWhite(c)) {
            c = this.readChar();
        }
        this.pushbackChar(c);
    }

    public String readString() {
        char[] cArray = new char[512];
        char c = '\u0000';
        int n = 0;
        this.skipWhite();
        while (!this.eof()) {
            c = this.readChar();
            if (ReadStream.isWhite(c)) {
                this.pushbackChar(c);
                break;
            }
            cArray[n++] = c;
        }
        return new String(cArray, 0, n);
    }

    private boolean acceptChar(char c) {
        char c2 = this.readChar();
        if (Character.toLowerCase(c) == Character.toLowerCase(c2)) {
            return true;
        }
        this.pushbackChar(c2);
        return false;
    }

    private boolean acceptWord(String string) {
        this.skipWhite();
        int n = 0;
        while (n < string.length()) {
            if (!this.acceptChar(string.charAt(n))) {
                int n2 = n - 1;
                while (n2 >= 0) {
                    this.pushbackChar(string.charAt(n2));
                    --n2;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean readBoolean() {
        if (this.acceptWord("true")) {
            return true;
        }
        if (!this.acceptWord("false")) {
            Assert.fail("Boolean not found on input.");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char readChar() {
        char c;
        block12: {
            boolean bl;
            block11: {
                c = '\u0000';
                try {
                    try {
                        if (this.atEOF) {
                            boolean bl2 = false;
                            Object var5_4 = null;
                            if (this.absorbNL && c == '\n') {
                                this.absorbNL = false;
                                c = this.readChar();
                            }
                            bl = c == '\r';
                            break block11;
                        }
                        c = this.buffertop >= 0 ? this.buffer[this.buffertop--] : (char)((char)this.strm.readByte());
                        break block12;
                    }
                    catch (EOFException eOFException) {
                        this.atEOF = true;
                        Object var5_6 = null;
                        if (this.absorbNL && c == '\n') {
                            this.absorbNL = false;
                            c = this.readChar();
                        }
                        this.absorbNL = c == '\r';
                        return c;
                    }
                    catch (IOException iOException) {
                        Assert.fail("Input error free.");
                        Object var5_7 = null;
                        if (this.absorbNL && c == '\n') {
                            this.absorbNL = false;
                            c = this.readChar();
                        }
                        this.absorbNL = c == '\r';
                        return c;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    if (this.absorbNL && c == '\n') {
                        this.absorbNL = false;
                        c = this.readChar();
                    }
                    this.absorbNL = c == '\r';
                    return c;
                }
            }
            this.absorbNL = bl;
            return c;
        }
        Object var5_5 = null;
        if (this.absorbNL && c == '\n') {
            this.absorbNL = false;
            c = this.readChar();
        }
        this.absorbNL = c == '\r';
        return c;
    }

    public void pushbackChar(char c) {
        if (c == '\u0000') {
            return;
        }
        this.atEOF = false;
        ++this.buffertop;
        if (this.buffertop == this.buffersize) {
            char[] cArray = this.buffer;
            this.buffersize *= 2;
            this.buffer = new char[this.buffersize];
            int n = 0;
            while (n < this.buffertop) {
                this.buffer[n] = cArray[n];
                ++n;
            }
        }
        this.buffer[this.buffertop] = c;
        this.absorbNL = false;
    }

    public double readDouble() {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipWhite();
        if (this.acceptChar('+')) {
            stringBuffer.append('+');
        } else if (this.acceptChar('-')) {
            stringBuffer.append('-');
        }
        char c = this.readChar();
        while (Character.isDigit(c)) {
            stringBuffer.append(c);
            c = this.readChar();
        }
        this.pushbackChar(c);
        if (this.acceptChar('.')) {
            stringBuffer.append('.');
            c = this.readChar();
            while (Character.isDigit(c)) {
                stringBuffer.append(c);
                c = this.readChar();
            }
            this.pushbackChar(c);
        }
        if (this.acceptChar('E')) {
            stringBuffer.append('E');
            if (this.acceptChar('+')) {
                stringBuffer.append('+');
            } else if (this.acceptChar('-')) {
                stringBuffer.append('-');
            }
            c = this.readChar();
            while (Character.isDigit(c)) {
                stringBuffer.append(c);
                c = this.readChar();
            }
            this.pushbackChar(c);
        }
        String string = stringBuffer.toString();
        return Double.valueOf(string);
    }

    public float readFloat() {
        return (float)this.readDouble();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.strm.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.strm.readFully(byArray, n, n2);
    }

    public short readShort() {
        return (short)this.readLong();
    }

    public int readInt() {
        return (int)this.readLong();
    }

    public long readLong() {
        boolean bl = false;
        int n = 0;
        long l = 0L;
        int n2 = 10;
        this.skipWhite();
        if (this.eof()) {
            return 0L;
        }
        while (!this.eof()) {
            char c = this.readChar();
            if (n == 0 && c == '-') {
                bl = true;
                continue;
            }
            if (n == 0 && c == '0') {
                n2 = 8;
                ++n;
                continue;
            }
            if (n == 1 && n2 == 8 && (c == 'x' || c == 'X')) {
                n2 = 16;
                ++n;
                continue;
            }
            int n3 = c - 48;
            if (c >= 'a' && c <= 'f') {
                n3 = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                n3 = c - 65 + 10;
            }
            if (n3 < 0 || n3 >= n2) {
                this.pushbackChar(c);
                break;
            }
            ++n;
            l = l * (long)n2 + (long)n3;
        }
        if (bl) {
            l = -l;
        }
        return l;
    }

    public String readLine() {
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.eoln()) {
            stringBuffer.append(this.readChar());
        }
        this.readChar();
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        return this.strm.readUTF();
    }
}

