/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractQueue;
import structure.ArrayIterator;
import structure.Assert;
import structure.Queue;

public class QueueArray
extends AbstractQueue
implements Queue {
    protected Object[] data;
    protected int head;
    protected int count;

    public QueueArray(int n) {
        this.data = new Object[n];
        this.head = 0;
        this.count = 0;
    }

    public void add(Object object) {
        Assert.pre(!this.isFull(), "Queue is not full.");
        int n = (this.head + this.count) % this.data.length;
        this.data[n] = object;
        ++this.count;
    }

    public Object remove() {
        Assert.pre(!this.isEmpty(), "The queue is not empty.");
        Object object = this.data[this.head];
        this.head = (this.head + 1) % this.data.length;
        --this.count;
        return object;
    }

    public Object get() {
        Assert.pre(!this.isEmpty(), "The queue is not empty.");
        return this.data[this.head];
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.head = 0;
    }

    public boolean isFull() {
        return this.count == this.data.length;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Iterator iterator() {
        return new ArrayIterator(this.data, this.head, this.count);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<QueueArray:");
        int n = 0;
        int n2 = this.head;
        while (n < this.count) {
            stringBuffer.append(" " + this.data[n2]);
            ++n;
            n2 = (n2 + 1) % this.data.length;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

