/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Comparator;
import java.util.Iterator;
import structure.AbstractStructure;
import structure.NaturalComparator;
import structure.OrderedStructure;
import structure.SinglyLinkedListElement;
import structure.SinglyLinkedListIterator;

public class OrderedList
extends AbstractStructure
implements OrderedStructure {
    protected SinglyLinkedListElement data;
    protected int count;
    protected Comparator ordering;

    public OrderedList() {
        this(new NaturalComparator());
    }

    public OrderedList(Comparator comparator) {
        this.ordering = comparator;
        this.clear();
    }

    public void clear() {
        this.data = null;
        this.count = 0;
    }

    public void add(Object object) {
        SinglyLinkedListElement singlyLinkedListElement = null;
        SinglyLinkedListElement singlyLinkedListElement2 = this.data;
        Comparable comparable = (Comparable)object;
        while (singlyLinkedListElement2 != null && this.ordering.compare(singlyLinkedListElement2.value(), comparable) < 0) {
            singlyLinkedListElement = singlyLinkedListElement2;
            singlyLinkedListElement2 = singlyLinkedListElement2.next();
        }
        if (singlyLinkedListElement == null) {
            this.data = new SinglyLinkedListElement(comparable, this.data);
        } else {
            singlyLinkedListElement.setNext(new SinglyLinkedListElement(comparable, singlyLinkedListElement.next()));
        }
        ++this.count;
    }

    public boolean contains(Object object) {
        SinglyLinkedListElement singlyLinkedListElement = this.data;
        Comparable comparable = (Comparable)object;
        while (singlyLinkedListElement != null && this.ordering.compare(singlyLinkedListElement.value(), comparable) < 0) {
            singlyLinkedListElement = singlyLinkedListElement.next();
        }
        return singlyLinkedListElement != null && comparable.equals(singlyLinkedListElement.value());
    }

    public Object remove(Object object) {
        SinglyLinkedListElement singlyLinkedListElement = null;
        SinglyLinkedListElement singlyLinkedListElement2 = this.data;
        Comparable comparable = (Comparable)object;
        while (singlyLinkedListElement2 != null && this.ordering.compare(singlyLinkedListElement2.value(), comparable) < 0) {
            singlyLinkedListElement = singlyLinkedListElement2;
            singlyLinkedListElement2 = singlyLinkedListElement2.next();
        }
        if (singlyLinkedListElement2 != null && comparable.equals(singlyLinkedListElement2.value())) {
            if (singlyLinkedListElement == null) {
                this.data = singlyLinkedListElement2.next();
            } else {
                singlyLinkedListElement.setNext(singlyLinkedListElement2.next());
            }
            --this.count;
            return singlyLinkedListElement2.value();
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new SinglyLinkedListIterator(this.data);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<OrderedList:");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" " + iterator.next());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

