/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.Assert;
import structure.Vector;

public class Matrix {
    protected int height;
    protected int width;
    protected Vector rows;

    public Matrix() {
        this(0, 0);
    }

    public Matrix(int n, int n2) {
        this.height = n;
        this.width = n2;
        this.rows = new Vector(this.height);
        int n3 = 0;
        while (n3 < this.height) {
            Vector vector = new Vector(this.width);
            this.rows.add(vector);
            int n4 = 0;
            while (n4 < this.width) {
                vector.add(null);
                ++n4;
            }
            ++n3;
        }
    }

    public Object get(int n, int n2) {
        Assert.pre(0 <= n && n < this.height, "Row in bounds.");
        Assert.pre(0 <= n2 && n2 < this.width, "Col in bounds.");
        Vector vector = (Vector)this.rows.get(n);
        return vector.get(n2);
    }

    public void set(int n, int n2, Object object) {
        Assert.pre(0 <= n && n < this.height, "Row in bounds.");
        Assert.pre(0 <= n2 && n2 < this.width, "Col in bounds.");
        Vector vector = (Vector)this.rows.get(n);
        vector.set(n2, object);
    }

    public void addRow(int n) {
        Assert.pre(0 <= n && n < this.width, "Row in bounds.");
        ++this.height;
        Vector vector = new Vector(this.width);
        int n2 = 0;
        while (n2 < this.width) {
            vector.add(null);
            ++n2;
        }
        this.rows.add(n, vector);
    }

    public void addCol(int n) {
        Assert.pre(0 <= n && n < this.width, "Col in bounds.");
        ++this.width;
        int n2 = 0;
        while (n2 < this.height) {
            Vector vector = (Vector)this.rows.get(n2);
            vector.add(n, null);
            ++n2;
        }
    }

    public Vector removeRow(int n) {
        Assert.pre(0 <= n && n < this.height, "There is a row to be removed.");
        Vector vector = (Vector)this.rows.get(n);
        --this.height;
        this.rows.remove(n);
        return vector;
    }

    public Vector removeCol(int n) {
        Assert.pre(0 <= n && n < this.width, "There is a column to be removed.");
        Vector vector = new Vector(this.height);
        --this.width;
        int n2 = 0;
        while (n2 < this.height) {
            Vector vector2 = (Vector)this.rows.get(n2);
            vector.add(vector2.get(n));
            vector2.remove(n);
            ++n2;
        }
        return vector;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Matrix:\n");
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                stringBuffer.append("  <Row " + n + ", Col " + n2 + ", value=");
                stringBuffer.append(this.get(n, n2) + ">");
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

