/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.Association;
import structure.List;
import structure.Map;
import structure.Set;
import structure.SetList;
import structure.SinglyLinkedList;
import structure.Structure;
import structure.ValueIterator;

public class MapList
implements Map {
    protected List data = new SinglyLinkedList();

    public MapList() {
    }

    public MapList(Map map) {
        this();
        this.putAll(map);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.data.contains(new Association(object, null));
    }

    public boolean containsValue(Object object) {
        ValueIterator valueIterator = new ValueIterator(this.data.iterator());
        while (valueIterator.hasNext()) {
            Object e = valueIterator.next();
            if (e == null || !object.equals(e)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object object) {
        int n = this.data.indexOf(new Association(object, null));
        if (n >= 0) {
            return ((Association)this.data.get(n)).getValue();
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Association association = new Association(object, object2);
        Association association2 = (Association)this.data.remove(association);
        this.data.add(association);
        if (association2 == null) {
            return null;
        }
        return association2.getValue();
    }

    public Object remove(Object object) {
        Association association = (Association)this.data.remove(new Association(object, null));
        if (association == null) {
            return null;
        }
        return association.getValue();
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            this.put(association.getKey(), association.getValue());
        }
    }

    public void clear() {
        this.data.clear();
    }

    public Set keySet() {
        SetList setList = new SetList();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            setList.add(association.getKey());
        }
        return setList;
    }

    public Structure values() {
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        ValueIterator valueIterator = new ValueIterator(this.data.iterator());
        while (valueIterator.hasNext()) {
            singlyLinkedList.add(valueIterator.next());
        }
        return singlyLinkedList;
    }

    public Set entrySet() {
        SetList setList = new SetList();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            setList.add(association);
        }
        return setList;
    }

    public boolean equals(Object object) {
        MapList mapList = (MapList)object;
        return this.data.equals(mapList.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

