/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.AbstractIterator;
import structure.Association;
import structure.Hashtable;

class HashtableIterator
extends AbstractIterator {
    protected int current;
    protected Association[] data;

    public HashtableIterator(Association[] associationArray) {
        this.data = associationArray;
        this.reset();
    }

    public void reset() {
        this.current = 0;
        while (this.current < this.data.length) {
            if (this.data[this.current] != null && this.data[this.current] != Hashtable.reserved) break;
            ++this.current;
        }
    }

    public boolean hasNext() {
        return this.current < this.data.length;
    }

    public Object next() {
        Association association = this.data[this.current];
        ++this.current;
        while (this.current < this.data.length) {
            if (this.data[this.current] != null && this.data[this.current] != Hashtable.reserved) break;
            ++this.current;
        }
        return association;
    }

    public Object get() {
        return this.data[this.current];
    }
}

