/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractIterator;
import structure.Association;
import structure.HashtableIterator;
import structure.KeyIterator;
import structure.Map;
import structure.Set;
import structure.SetList;
import structure.SinglyLinkedList;
import structure.Structure;
import structure.ValueIterator;

public class Hashtable
implements Map {
    protected static Association reserved = new Association("reserved", null);
    protected Association[] data;
    protected int count;
    protected int capacity;
    protected final double loadFactor = 0.6;

    public Hashtable(int n) {
        this.data = new Association[n];
        this.capacity = n;
        this.count = 0;
    }

    public Hashtable() {
        this(997);
    }

    public void clear() {
        int n = 0;
        while (n < this.capacity) {
            this.data[n] = null;
            ++n;
        }
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null || !e.equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        int n = this.locate(object);
        return this.data[n] != null && this.data[n] != reserved;
    }

    public Iterator iterator() {
        return new ValueIterator(new HashtableIterator(this.data));
    }

    public Object get(Object object) {
        int n = this.locate(object);
        Association association = this.data[n];
        if (association == null || association == reserved) {
            return null;
        }
        return this.data[n].getValue();
    }

    public Iterator keys() {
        return new KeyIterator(new HashtableIterator(this.data));
    }

    protected int locate(Object object) {
        int n = Math.abs(object.hashCode() % this.capacity);
        int n2 = -1;
        while (this.data[n] != null) {
            if (this.data[n] == reserved) {
                if (n2 == -1) {
                    n2 = n;
                }
            } else if (object.equals(this.data[n].getKey())) {
                return n;
            }
            n = (1 + n) % this.capacity;
        }
        if (n2 == -1) {
            return n;
        }
        return n2;
    }

    public Object put(Object object, Object object2) {
        int n;
        Association association;
        if (0.6 * (double)this.capacity <= (double)(1 + this.count)) {
            this.extend();
        }
        if ((association = this.data[n = this.locate(object)]) == null || association == reserved) {
            this.data[n] = new Association(object, object2);
            ++this.count;
            return null;
        }
        Object object3 = association.getValue();
        association.setValue(object2);
        return object3;
    }

    public void putAll(Map map) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            this.put(association.getKey(), association.getValue());
        }
    }

    public Object remove(Object object) {
        int n = this.locate(object);
        Association association = this.data[n];
        if (association == null || association == reserved) {
            return null;
        }
        --this.count;
        Object object2 = association.getValue();
        this.data[n] = reserved;
        return object2;
    }

    protected void extend() {
        HashtableIterator hashtableIterator = new HashtableIterator(this.data);
        this.capacity = this.capacity * 2 + 1;
        this.data = new Association[this.capacity];
        this.count = 0;
        while (((AbstractIterator)hashtableIterator).hasNext()) {
            Association association = (Association)((AbstractIterator)hashtableIterator).next();
            this.put(association.getKey(), association.getValue());
        }
    }

    public Set entrySet() {
        SetList setList = new SetList();
        HashtableIterator hashtableIterator = new HashtableIterator(this.data);
        while (hashtableIterator.hasNext()) {
            setList.add(hashtableIterator.next());
        }
        return setList;
    }

    public Set keySet() {
        SetList setList = new SetList();
        KeyIterator keyIterator = new KeyIterator(new HashtableIterator(this.data));
        while (keyIterator.hasNext()) {
            setList.add(keyIterator.next());
        }
        return setList;
    }

    public Structure values() {
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        ValueIterator valueIterator = new ValueIterator(new HashtableIterator(this.data));
        while (valueIterator.hasNext()) {
            singlyLinkedList.add(valueIterator.next());
        }
        return singlyLinkedList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Hashtable: size=" + this.size() + " capacity=" + this.capacity);
        HashtableIterator hashtableIterator = new HashtableIterator(this.data);
        while (hashtableIterator.hasNext()) {
            Association association = (Association)hashtableIterator.next();
            stringBuffer.append(" key=" + association.getKey() + ", value=" + association.getValue());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

