/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractStructure;
import structure.Assert;
import structure.Edge;
import structure.Graph;
import structure.GraphMatrixVertex;
import structure.Hashtable;
import structure.List;
import structure.Map;
import structure.SinglyLinkedList;
import structure.Vertex;

public abstract class GraphMatrix
extends AbstractStructure
implements Graph {
    protected int size;
    protected Edge[][] data;
    protected Map dict;
    protected List freeList;
    protected boolean directed;

    protected GraphMatrix(int n, boolean bl) {
        this.size = n;
        this.directed = bl;
        this.data = new Edge[n][n];
        this.dict = new Hashtable(n);
        this.freeList = new SinglyLinkedList();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.freeList.add(new Integer(n2));
            --n2;
        }
    }

    public void add(Object object) {
        if (this.dict.containsKey(object)) {
            return;
        }
        Assert.pre(!this.freeList.isEmpty(), "Matrix not full");
        int n = (Integer)this.freeList.removeFirst();
        this.dict.put(object, new GraphMatrixVertex(object, n));
    }

    public abstract void addEdge(Object var1, Object var2, Object var3);

    public Object remove(Object object) {
        GraphMatrixVertex graphMatrixVertex = (GraphMatrixVertex)this.dict.remove(object);
        if (graphMatrixVertex == null) {
            return null;
        }
        int n = graphMatrixVertex.index();
        int n2 = 0;
        while (n2 < this.size) {
            this.data[n2][n] = null;
            this.data[n][n2] = null;
            ++n2;
        }
        this.freeList.add(new Integer(n));
        return graphMatrixVertex.label();
    }

    public abstract Object removeEdge(Object var1, Object var2);

    public Object get(Object object) {
        GraphMatrixVertex graphMatrixVertex = (GraphMatrixVertex)this.dict.get(object);
        return graphMatrixVertex.label();
    }

    public Edge getEdge(Object object, Object object2) {
        int n = ((GraphMatrixVertex)this.dict.get(object)).index();
        int n2 = ((GraphMatrixVertex)this.dict.get(object2)).index();
        return this.data[n][n2];
    }

    public boolean contains(Object object) {
        return this.dict.containsKey(object);
    }

    public boolean containsEdge(Object object, Object object2) {
        GraphMatrixVertex graphMatrixVertex = (GraphMatrixVertex)this.dict.get(object);
        GraphMatrixVertex graphMatrixVertex2 = (GraphMatrixVertex)this.dict.get(object2);
        Assert.condition(graphMatrixVertex != null, "Vertex exists");
        Assert.condition(graphMatrixVertex2 != null, "Vertex exists");
        return this.data[graphMatrixVertex.index()][graphMatrixVertex2.index()] != null;
    }

    public boolean visit(Object object) {
        Vertex vertex = (Vertex)this.dict.get(object);
        return vertex.visit();
    }

    public boolean visitEdge(Edge edge) {
        return edge.visit();
    }

    public boolean isVisited(Object object) {
        GraphMatrixVertex graphMatrixVertex = (GraphMatrixVertex)this.dict.get(object);
        return graphMatrixVertex.isVisited();
    }

    public boolean isVisitedEdge(Edge edge) {
        return edge.isVisited();
    }

    public void reset() {
        Iterator iterator = this.dict.values().iterator();
        while (iterator.hasNext()) {
            ((GraphMatrixVertex)iterator.next()).reset();
        }
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                Edge edge = this.data[n][n2];
                if (edge != null) {
                    edge.reset();
                }
                ++n2;
            }
            ++n;
        }
    }

    public int size() {
        return this.dict.size();
    }

    public int degree(Object object) {
        int n = ((GraphMatrixVertex)this.dict.get(object)).index();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if (this.data[n][n3] != null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public abstract int edgeCount();

    public Iterator iterator() {
        return this.dict.keySet().iterator();
    }

    public Iterator neighbors(Object object) {
        GraphMatrixVertex graphMatrixVertex = (GraphMatrixVertex)this.dict.get(object);
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        int n = this.size - 1;
        while (n >= 0) {
            Edge edge = this.data[graphMatrixVertex.index()][n];
            if (edge != null) {
                if (edge.here().equals(graphMatrixVertex.label())) {
                    singlyLinkedList.add(edge.there());
                } else {
                    singlyLinkedList.add(edge.here());
                }
            }
            --n;
        }
        return singlyLinkedList.iterator();
    }

    public abstract Iterator edges();

    public void clear() {
        this.dict.clear();
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < this.size) {
                this.data[n][n2] = null;
                ++n2;
            }
            ++n;
        }
        this.freeList = new SinglyLinkedList();
        int n3 = this.size - 1;
        while (n3 >= 0) {
            this.freeList.add(new Integer(n3));
            --n3;
        }
    }

    public boolean isEmpty() {
        return this.dict.isEmpty();
    }

    public boolean isDirected() {
        return this.directed;
    }
}

