/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.Edge;
import structure.GraphListAIterator;
import structure.SinglyLinkedList;
import structure.Structure;
import structure.Vertex;

class GraphListVertex
extends Vertex {
    protected Structure adjacencies = new SinglyLinkedList();

    public GraphListVertex(Object object) {
        super(object);
    }

    public void addEdge(Edge edge) {
        if (!this.containsEdge(edge)) {
            this.adjacencies.add(edge);
        }
    }

    public boolean containsEdge(Edge edge) {
        return this.adjacencies.contains(edge);
    }

    public Edge removeEdge(Edge edge) {
        return (Edge)this.adjacencies.remove(edge);
    }

    public Edge getEdge(Edge edge) {
        Iterator iterator = this.adjacencies.iterator();
        while (iterator.hasNext()) {
            Edge edge2 = (Edge)iterator.next();
            if (!edge.equals(edge2)) continue;
            return edge2;
        }
        return null;
    }

    public int degree() {
        return this.adjacencies.size();
    }

    public Iterator adjacentVertices() {
        return new GraphListAIterator(this.adjacentEdges(), this.label());
    }

    public Iterator adjacentEdges() {
        return this.adjacencies.iterator();
    }

    public String toString() {
        return "<GraphListVertex: " + this.label() + ">";
    }
}

