/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractStructure;
import structure.Assert;
import structure.Association;
import structure.ComparableAssociation;
import structure.Edge;
import structure.Graph;
import structure.GraphListDirected;
import structure.GraphListEIterator;
import structure.GraphListVertex;
import structure.Hashtable;
import structure.Map;
import structure.SkewHeap;
import structure.Vertex;

public abstract class GraphList
extends AbstractStructure
implements Graph {
    protected Map dict = new Hashtable();
    protected boolean directed;

    protected GraphList(boolean bl) {
        this.directed = bl;
    }

    public void add(Object object) {
        if (this.dict.containsKey(object)) {
            return;
        }
        GraphListVertex graphListVertex = new GraphListVertex(object);
        this.dict.put(object, graphListVertex);
    }

    public abstract void addEdge(Object var1, Object var2, Object var3);

    public abstract Object remove(Object var1);

    public abstract Object removeEdge(Object var1, Object var2);

    public Object get(Object object) {
        Assert.condition(this.dict.containsKey(object), "Vertex exists");
        return ((GraphListVertex)this.dict.get(object)).label();
    }

    public Edge getEdge(Object object, Object object2) {
        Assert.condition(this.dict.containsKey(object), "Vertex exists");
        Edge edge = new Edge(this.get(object), this.get(object2), null, this.directed);
        return ((GraphListVertex)this.dict.get(object)).getEdge(edge);
    }

    public boolean contains(Object object) {
        return this.dict.containsKey(object);
    }

    public boolean containsEdge(Object object, Object object2) {
        Assert.condition(this.dict.containsKey(object), "Vertex exists");
        Edge edge = new Edge(object, object2, null, this.directed);
        return ((GraphListVertex)this.dict.get(object)).containsEdge(edge);
    }

    public boolean visit(Object object) {
        return ((GraphListVertex)this.dict.get(object)).visit();
    }

    public boolean visitEdge(Edge edge) {
        return edge.visit();
    }

    public boolean isVisited(Object object) {
        return ((GraphListVertex)this.dict.get(object)).isVisited();
    }

    public boolean isVisitedEdge(Edge edge) {
        return edge.isVisited();
    }

    public void reset() {
        Object object;
        Iterator iterator = this.dict.values().iterator();
        while (iterator.hasNext()) {
            object = (Vertex)iterator.next();
            ((Vertex)object).reset();
        }
        object = this.edges();
        while (object.hasNext()) {
            Edge edge = (Edge)object.next();
            edge.reset();
        }
    }

    public int size() {
        return this.dict.size();
    }

    public int degree(Object object) {
        Assert.condition(this.dict.containsKey(object), "Vertex exists.");
        return ((GraphListVertex)this.dict.get(object)).degree();
    }

    public abstract int edgeCount();

    public Iterator iterator() {
        return this.dict.keySet().iterator();
    }

    public Iterator neighbors(Object object) {
        Assert.condition(this.dict.containsKey(object), "Vertex exists");
        return ((GraphListVertex)this.dict.get(object)).adjacentVertices();
    }

    public Iterator edges() {
        return new GraphListEIterator(this.dict);
    }

    public void clear() {
        this.dict.clear();
    }

    public boolean isEmpty() {
        return this.dict.isEmpty();
    }

    public boolean isDirected() {
        return this.directed;
    }

    public static void main(String[] stringArray) {
        Object object;
        GraphListDirected graphListDirected = new GraphListDirected();
        SkewHeap skewHeap = new SkewHeap();
        String[] stringArray2 = new String[]{"TCL 312", "Images Cinema", "Movie Plex 3", "Cinema 1,2,&3", "Cinema 7", "Berkshire Mall Cinemas", "Hathaway's Drive Inn Theatre", "Hollywood Drive-In Theatre"};
        double[] dArray = new double[]{-1.0, 0.0, 12.6, 12.9, 12.9, 14.7, 16.5, 18.0};
        int n = 0;
        while (n < stringArray2.length) {
            graphListDirected.add(stringArray2[n]);
            ++n;
        }
        int n2 = 1;
        while (n2 < dArray.length) {
            graphListDirected.addEdge(stringArray2[0], stringArray2[n2], new Double(dArray[n2]));
            ++n2;
        }
        Iterator iterator = graphListDirected.neighbors(stringArray2[0]);
        while (iterator.hasNext()) {
            object = iterator.next();
            Object object2 = graphListDirected.getEdge(stringArray2[0], object).label();
            skewHeap.add(new ComparableAssociation((Comparable)object2, object));
        }
        while (!skewHeap.isEmpty()) {
            object = (ComparableAssociation)skewHeap.remove();
            System.out.println(((Association)object).getValue() + " is " + ((Association)object).getKey() + " miles away.");
        }
    }
}

