/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractList;
import structure.Assert;
import structure.DoublyLinkedListElement;
import structure.DoublyLinkedListIterator;

public class DoublyLinkedList
extends AbstractList {
    protected int count = 0;
    protected DoublyLinkedListElement head = null;
    protected DoublyLinkedListElement tail = null;

    public void add(Object object) {
        this.addFirst(object);
    }

    public void addFirst(Object object) {
        this.head = new DoublyLinkedListElement(object, this.head, null);
        if (this.tail == null) {
            this.tail = this.head;
        }
        ++this.count;
    }

    public Object removeFirst() {
        Assert.pre(!this.isEmpty(), "List is not empty.");
        DoublyLinkedListElement doublyLinkedListElement = this.head;
        this.head = this.head.next();
        if (this.head != null) {
            this.head.setPrevious(null);
        } else {
            this.tail = null;
        }
        doublyLinkedListElement.setNext(null);
        --this.count;
        return doublyLinkedListElement.value();
    }

    public void addLast(Object object) {
        this.tail = new DoublyLinkedListElement(object, null, this.tail);
        if (this.head == null) {
            this.head = this.tail;
        }
        ++this.count;
    }

    public Object removeLast() {
        Assert.pre(!this.isEmpty(), "List is not empty.");
        DoublyLinkedListElement doublyLinkedListElement = this.tail;
        this.tail = this.tail.previous();
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.setNext(null);
        }
        --this.count;
        return doublyLinkedListElement.value();
    }

    public Object getFirst() {
        return this.head.value();
    }

    public Object getLast() {
        return this.tail.value();
    }

    public boolean contains(Object object) {
        DoublyLinkedListElement doublyLinkedListElement = this.head;
        while (doublyLinkedListElement != null && !doublyLinkedListElement.value().equals(object)) {
            doublyLinkedListElement = doublyLinkedListElement.next();
        }
        return doublyLinkedListElement != null;
    }

    public Object remove(Object object) {
        DoublyLinkedListElement doublyLinkedListElement = this.head;
        while (doublyLinkedListElement != null && !doublyLinkedListElement.value().equals(object)) {
            doublyLinkedListElement = doublyLinkedListElement.next();
        }
        if (doublyLinkedListElement != null) {
            if (doublyLinkedListElement.previous() != null) {
                doublyLinkedListElement.previous().setNext(doublyLinkedListElement.next());
            } else {
                this.head = doublyLinkedListElement.next();
            }
            if (doublyLinkedListElement.next() != null) {
                doublyLinkedListElement.next().setPrevious(doublyLinkedListElement.previous());
            } else {
                this.tail = doublyLinkedListElement.previous();
            }
            --this.count;
            return doublyLinkedListElement.value();
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.tail = null;
        this.head = null;
        this.count = 0;
    }

    public Object get(int n) {
        if (n >= this.size()) {
            return null;
        }
        DoublyLinkedListElement doublyLinkedListElement = this.head;
        while (n > 0) {
            doublyLinkedListElement = doublyLinkedListElement.next();
            --n;
        }
        return doublyLinkedListElement.value();
    }

    public Object set(int n, Object object) {
        if (n >= this.size()) {
            return null;
        }
        DoublyLinkedListElement doublyLinkedListElement = this.head;
        while (n > 0) {
            doublyLinkedListElement = doublyLinkedListElement.next();
            --n;
        }
        Object object2 = doublyLinkedListElement.value();
        doublyLinkedListElement.setValue(object);
        return object2;
    }

    public void add(int n, Object object) {
        Assert.pre(0 <= n && n <= this.size(), "Index in range.");
        if (n == 0) {
            this.addFirst(object);
        } else if (n == this.size()) {
            this.addLast(object);
        } else {
            DoublyLinkedListElement doublyLinkedListElement = null;
            DoublyLinkedListElement doublyLinkedListElement2 = this.head;
            while (n > 0) {
                doublyLinkedListElement = doublyLinkedListElement2;
                doublyLinkedListElement2 = doublyLinkedListElement2.next();
                --n;
            }
            DoublyLinkedListElement doublyLinkedListElement3 = new DoublyLinkedListElement(object, doublyLinkedListElement2, doublyLinkedListElement);
            ++this.count;
            doublyLinkedListElement.setNext(doublyLinkedListElement3);
            doublyLinkedListElement2.setPrevious(doublyLinkedListElement3);
        }
    }

    public Object remove(int n) {
        Assert.pre(0 <= n && n < this.size(), "Index in range.");
        if (n == 0) {
            return this.removeFirst();
        }
        if (n == this.size() - 1) {
            return this.removeLast();
        }
        DoublyLinkedListElement doublyLinkedListElement = null;
        DoublyLinkedListElement doublyLinkedListElement2 = this.head;
        while (n > 0) {
            doublyLinkedListElement = doublyLinkedListElement2;
            doublyLinkedListElement2 = doublyLinkedListElement2.next();
            --n;
        }
        doublyLinkedListElement.setNext(doublyLinkedListElement2.next());
        doublyLinkedListElement2.next().setPrevious(doublyLinkedListElement);
        --this.count;
        return doublyLinkedListElement2.value();
    }

    public int indexOf(Object object) {
        int n = 0;
        DoublyLinkedListElement doublyLinkedListElement = this.head;
        while (doublyLinkedListElement != null && !doublyLinkedListElement.value().equals(object)) {
            doublyLinkedListElement = doublyLinkedListElement.next();
            ++n;
        }
        if (doublyLinkedListElement == null) {
            return -1;
        }
        return n;
    }

    public int lastIndexOf(Object object) {
        int n = this.size() - 1;
        DoublyLinkedListElement doublyLinkedListElement = this.tail;
        while (doublyLinkedListElement != null && !doublyLinkedListElement.value().equals(object)) {
            doublyLinkedListElement = doublyLinkedListElement.previous();
            --n;
        }
        if (doublyLinkedListElement == null) {
            return -1;
        }
        return n;
    }

    public Iterator iterator() {
        return new DoublyLinkedListIterator(this.head);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<DoublyLinkedList:");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" " + iterator.next());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

