/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractList;
import structure.Assert;
import structure.CircularListIterator;
import structure.SinglyLinkedListElement;

public class CircularList
extends AbstractList {
    protected SinglyLinkedListElement tail = null;
    protected int count = 0;

    public void add(Object object) {
        this.addFirst(object);
    }

    public void addFirst(Object object) {
        SinglyLinkedListElement singlyLinkedListElement = new SinglyLinkedListElement(object);
        if (this.tail == null) {
            this.tail = singlyLinkedListElement;
            this.tail.setNext(this.tail);
        } else {
            singlyLinkedListElement.setNext(this.tail.next());
            this.tail.setNext(singlyLinkedListElement);
        }
        ++this.count;
    }

    public void addLast(Object object) {
        this.addFirst(object);
        this.tail = this.tail.next();
    }

    public Object getFirst() {
        return this.tail.next().value();
    }

    public Object getLast() {
        return this.tail.value();
    }

    public Object removeFirst() {
        SinglyLinkedListElement singlyLinkedListElement = this.tail.next();
        if (this.tail == this.tail.next()) {
            this.tail = null;
        } else {
            this.tail.setNext(singlyLinkedListElement.next());
            singlyLinkedListElement.setNext(null);
        }
        --this.count;
        return singlyLinkedListElement.value();
    }

    public Object removeLast() {
        Assert.pre(!this.isEmpty(), "list is not empty.");
        SinglyLinkedListElement singlyLinkedListElement = this.tail;
        while (singlyLinkedListElement.next() != this.tail) {
            singlyLinkedListElement = singlyLinkedListElement.next();
        }
        SinglyLinkedListElement singlyLinkedListElement2 = this.tail;
        if (singlyLinkedListElement == this.tail) {
            this.tail = null;
        } else {
            singlyLinkedListElement.setNext(this.tail.next());
            this.tail = singlyLinkedListElement;
        }
        --this.count;
        return singlyLinkedListElement2.value();
    }

    public boolean contains(Object object) {
        if (this.tail == null) {
            return false;
        }
        SinglyLinkedListElement singlyLinkedListElement = this.tail.next();
        while (singlyLinkedListElement != this.tail && !singlyLinkedListElement.value().equals(object)) {
            singlyLinkedListElement = singlyLinkedListElement.next();
        }
        return singlyLinkedListElement.value().equals(object);
    }

    public Object remove(Object object) {
        if (this.tail == null) {
            return null;
        }
        SinglyLinkedListElement singlyLinkedListElement = this.tail.next();
        SinglyLinkedListElement singlyLinkedListElement2 = this.tail;
        int n = 0;
        while (n < this.count && !singlyLinkedListElement.value().equals(object)) {
            singlyLinkedListElement2 = singlyLinkedListElement;
            singlyLinkedListElement = singlyLinkedListElement.next();
            ++n;
        }
        if (singlyLinkedListElement.value().equals(object)) {
            if (this.tail == this.tail.next()) {
                this.tail = null;
            } else {
                if (singlyLinkedListElement == this.tail) {
                    this.tail = singlyLinkedListElement2;
                }
                singlyLinkedListElement2.setNext(singlyLinkedListElement2.next().next());
            }
            singlyLinkedListElement.setNext(null);
            --this.count;
            return singlyLinkedListElement.value();
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public Object get(int n) {
        if (n >= this.size()) {
            return null;
        }
        SinglyLinkedListElement singlyLinkedListElement = this.tail.next();
        while (n > 0) {
            singlyLinkedListElement = singlyLinkedListElement.next();
            --n;
        }
        return singlyLinkedListElement.value();
    }

    protected SinglyLinkedListElement getTail() {
        return this.tail;
    }

    public Object set(int n, Object object) {
        if (n >= this.size()) {
            return null;
        }
        SinglyLinkedListElement singlyLinkedListElement = this.tail.next();
        while (n > 0) {
            singlyLinkedListElement = singlyLinkedListElement.next();
            --n;
        }
        Object object2 = singlyLinkedListElement.value();
        singlyLinkedListElement.setValue(object);
        return object2;
    }

    public void add(int n, Object object) {
        Assert.pre(0 <= n && n <= this.size(), "Index in range.");
        if (n == 0) {
            this.addFirst(object);
        } else if (n == this.size()) {
            this.addLast(object);
        } else {
            SinglyLinkedListElement singlyLinkedListElement = this.tail;
            SinglyLinkedListElement singlyLinkedListElement2 = this.tail.next();
            while (n > 0) {
                singlyLinkedListElement = singlyLinkedListElement2;
                singlyLinkedListElement2 = singlyLinkedListElement2.next();
                --n;
            }
            SinglyLinkedListElement singlyLinkedListElement3 = new SinglyLinkedListElement(object, singlyLinkedListElement2);
            ++this.count;
            singlyLinkedListElement.setNext(singlyLinkedListElement3);
        }
    }

    public Object remove(int n) {
        Assert.pre(0 <= n && n < this.size(), "Index in range.");
        if (n == 0) {
            return this.removeFirst();
        }
        if (n == this.size() - 1) {
            return this.removeLast();
        }
        SinglyLinkedListElement singlyLinkedListElement = this.tail;
        SinglyLinkedListElement singlyLinkedListElement2 = this.tail.next();
        while (n > 0) {
            --n;
            singlyLinkedListElement = singlyLinkedListElement2;
            singlyLinkedListElement2 = singlyLinkedListElement2.next();
        }
        singlyLinkedListElement.setNext(singlyLinkedListElement2.next());
        --this.count;
        return singlyLinkedListElement2.value();
    }

    public int indexOf(Object object) {
        int n = 0;
        SinglyLinkedListElement singlyLinkedListElement = this.tail.next();
        while (singlyLinkedListElement != null && !singlyLinkedListElement.value().equals(object)) {
            singlyLinkedListElement = singlyLinkedListElement == this.tail ? null : singlyLinkedListElement.next();
            ++n;
        }
        if (singlyLinkedListElement == null) {
            return -1;
        }
        return n;
    }

    public int lastIndexOf(Object object) {
        int n = -1;
        int n2 = 0;
        SinglyLinkedListElement singlyLinkedListElement = this.tail.next();
        while (singlyLinkedListElement != null) {
            if (singlyLinkedListElement.value().equals(object)) {
                n = n2;
            }
            singlyLinkedListElement = singlyLinkedListElement == this.tail ? null : singlyLinkedListElement.next();
            ++n2;
        }
        return n;
    }

    public Iterator iterator() {
        return new CircularListIterator(this.tail);
    }

    public boolean isEmpty() {
        return this.tail == null;
    }

    public void clear() {
        this.count = 0;
        this.tail = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<CircularList:");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" " + iterator.next());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

