/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractMap;
import structure.Association;
import structure.ChainedHashtableIterator;
import structure.KeyIterator;
import structure.List;
import structure.Map;
import structure.Set;
import structure.SetList;
import structure.SinglyLinkedList;
import structure.Structure;
import structure.ValueIterator;

public class ChainedHashtable
extends AbstractMap
implements Map {
    protected List[] data;
    protected int count;
    protected int capacity;

    public ChainedHashtable(int n) {
        this.data = new List[n];
        this.capacity = n;
        this.count = 0;
    }

    public ChainedHashtable() {
        this(997);
    }

    public void clear() {
        int n = 0;
        while (n < this.capacity) {
            this.data[n].clear();
            ++n;
        }
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected List locate(Object object) {
        int n = Math.abs(object.hashCode() % this.capacity);
        if (this.data[n] == null) {
            this.data[n] = new SinglyLinkedList();
        }
        return this.data[n];
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!object.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        List list = this.locate(object);
        return list.contains(new Association(object, null));
    }

    public Iterator iterator() {
        return new ValueIterator(new ChainedHashtableIterator(this.data));
    }

    public Set keySet() {
        SetList setList = new SetList();
        KeyIterator keyIterator = new KeyIterator(new ChainedHashtableIterator(this.data));
        while (keyIterator.hasNext()) {
            setList.add(keyIterator.next());
        }
        return setList;
    }

    public Set entrySet() {
        SetList setList = new SetList();
        ChainedHashtableIterator chainedHashtableIterator = new ChainedHashtableIterator(this.data);
        while (chainedHashtableIterator.hasNext()) {
            setList.add(chainedHashtableIterator.next());
        }
        return setList;
    }

    public Structure values() {
        SinglyLinkedList singlyLinkedList = new SinglyLinkedList();
        ValueIterator valueIterator = new ValueIterator(new ChainedHashtableIterator(this.data));
        while (valueIterator.hasNext()) {
            singlyLinkedList.add(valueIterator.next());
        }
        return singlyLinkedList;
    }

    public Object get(Object object) {
        List list = this.locate(object);
        Association association = (Association)list.remove(new Association(object, null));
        if (association == null) {
            return null;
        }
        list.addFirst(association);
        return association.getValue();
    }

    public Iterator keys() {
        return new KeyIterator(new ChainedHashtableIterator(this.data));
    }

    public Object put(Object object, Object object2) {
        List list = this.locate(object);
        Association association = new Association(object, object2);
        Association association2 = (Association)list.remove(association);
        list.addFirst(association);
        if (association2 != null) {
            return association2.getValue();
        }
        ++this.count;
        return null;
    }

    public Object remove(Object object) {
        List list = this.locate(object);
        Association association = (Association)list.remove(new Association(object, null));
        if (association == null) {
            return null;
        }
        --this.count;
        return association.getValue();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ChainedHashtable:");
        ChainedHashtableIterator chainedHashtableIterator = new ChainedHashtableIterator(this.data);
        while (chainedHashtableIterator.hasNext()) {
            Association association = (Association)chainedHashtableIterator.next();
            stringBuffer.append(" " + association.getKey() + "=" + association.getValue());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

