/*
 * Decompiled with CFR 0.152.
 */
package structure;

public class BitSet {
    protected final int bitsPerInt = 32;
    protected final int initialCapacity = 256;
    protected int[] data;
    protected int allocated;

    public BitSet() {
        this.clear(256);
    }

    public BitSet(int n) {
        this.clear(n);
    }

    public void add(int n) {
        this.extend(n);
        int n2 = this.indexOf(n);
        int n3 = this.offsetOf(n);
        int n4 = n2;
        this.data[n4] = this.data[n4] | 1 << n3;
    }

    public void remove(int n) {
        if (this.probe(n)) {
            int n2 = this.indexOf(n);
            int n3 = this.offsetOf(n);
            int n4 = n2;
            this.data[n4] = this.data[n4] & ~(1 << n3);
        }
    }

    public boolean contains(int n) {
        return this.probe(n) && 0 != (this.data[this.indexOf(n)] & 1 << this.offsetOf(n));
    }

    public void clear() {
        this.clear(256);
    }

    public void clear(int n) {
        this.allocated = (n + 32 - 1) / 32;
        this.data = new int[this.allocated];
        int n2 = 0;
        while (n2 < this.allocated) {
            this.data[n2] = 0;
            ++n2;
        }
    }

    public Object clone() {
        BitSet bitSet = new BitSet(this.allocated * 32);
        int n = 0;
        while (n < this.allocated) {
            bitSet.data[n] = this.data[n];
            ++n;
        }
        return bitSet;
    }

    public Object union(BitSet bitSet) {
        int n = this.allocated;
        int n2 = bitSet.allocated;
        if (n < n2) {
            return bitSet.union(this);
        }
        BitSet bitSet2 = new BitSet(n * 32);
        int n3 = 0;
        while (n3 < n2) {
            bitSet2.data[n3] = this.data[n3] | bitSet.data[n3];
            ++n3;
        }
        while (n3 < n) {
            bitSet2.data[n3] = this.data[n3];
            ++n3;
        }
        return bitSet2;
    }

    public Object intersection(BitSet bitSet) {
        int n = this.allocated;
        int n2 = bitSet.allocated;
        if (n < n2) {
            return bitSet.intersection(this);
        }
        BitSet bitSet2 = new BitSet(n2 * 32);
        int n3 = 0;
        while (n3 < n2) {
            bitSet2.data[n3] = this.data[n3] & bitSet.data[n3];
            ++n3;
        }
        return bitSet2;
    }

    public Object difference(BitSet bitSet) {
        int n = this.allocated;
        int n2 = bitSet.allocated;
        BitSet bitSet2 = new BitSet(n * 32);
        if (n <= n2) {
            int n3 = 0;
            while (n3 < n) {
                bitSet2.data[n3] = this.data[n3] & ~bitSet.data[n3];
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                bitSet2.data[n4] = this.data[n4] & ~bitSet.data[n4];
                ++n4;
            }
            n4 = n2;
            while (n4 < n) {
                bitSet2.data[n4] = this.data[n4];
                ++n4;
            }
        }
        return bitSet2;
    }

    public boolean subset(BitSet bitSet) {
        int n = this.allocated;
        int n2 = bitSet.allocated;
        if (n <= n2) {
            int n3 = 0;
            while (n3 < n) {
                if (0 != (this.data[n3] & ~bitSet.data[n3])) {
                    return false;
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                if (0 != (this.data[n4] & ~bitSet.data[n4])) {
                    return false;
                }
                ++n4;
            }
            n4 = n2;
            while (n4 < n) {
                if (0 != this.data[n4]) {
                    return false;
                }
                ++n4;
            }
        }
        return true;
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.allocated) {
            if (this.data[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        BitSet bitSet = (BitSet)object;
        int n = this.allocated;
        int n2 = bitSet.allocated;
        if (n < n2) {
            return bitSet.equals(this);
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.data[n3] != bitSet.data[n3]) {
                return false;
            }
            ++n3;
        }
        n3 = n2;
        while (n3 < n) {
            if (this.data[n3] != 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected int indexOf(int n) {
        return n / 32;
    }

    protected int offsetOf(int n) {
        return n % 32;
    }

    protected void extend(int n) {
        if (!this.probe(n)) {
            int n2 = this.indexOf(n);
            int n3 = this.allocated;
            while (n3 <= n2) {
                n3 *= 2;
            }
            int[] nArray = new int[n3];
            int n4 = 0;
            while (n4 < this.allocated) {
                nArray[n4] = this.data[n4];
                ++n4;
            }
            n4 = this.allocated;
            while (n4 < n3) {
                nArray[n4] = 0;
                ++n4;
            }
            this.data = nArray;
            this.allocated = n3;
        }
    }

    protected boolean probe(int n) {
        int n2 = this.indexOf(n);
        return this.data.length > n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BitSet:");
        int n = 0;
        while (this.probe(n)) {
            if (this.contains(n)) {
                stringBuffer.append(" " + Integer.toString(n));
            }
            ++n;
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

