/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Iterator;
import structure.AbstractIterator;
import structure.BTInorderIterator;
import structure.BTLevelorderIterator;
import structure.BTPostorderIterator;
import structure.BTPreorderIterator;

public class BinaryTree {
    protected Object val;
    protected BinaryTree parent;
    protected BinaryTree left;
    protected BinaryTree right;
    public static final BinaryTree EMPTY = new BinaryTree();

    private BinaryTree() {
        this.val = null;
        this.parent = null;
        this.left = this.right = this;
    }

    public BinaryTree(Object object) {
        this.val = object;
        this.parent = null;
        this.left = this.right = EMPTY;
    }

    public BinaryTree(Object object, BinaryTree binaryTree, BinaryTree binaryTree2) {
        this(object);
        this.setLeft(binaryTree);
        this.setRight(binaryTree2);
    }

    public BinaryTree left() {
        return this.left;
    }

    public BinaryTree right() {
        return this.right;
    }

    public BinaryTree parent() {
        return this.parent;
    }

    public void setLeft(BinaryTree binaryTree) {
        if (this.isEmpty()) {
            return;
        }
        if (this.left.parent() == this) {
            this.left.setParent(null);
        }
        this.left = binaryTree;
        this.left.setParent(this);
    }

    public void setRight(BinaryTree binaryTree) {
        if (this.isEmpty()) {
            return;
        }
        if (this.right.parent() == this) {
            this.right.setParent(null);
        }
        this.right = binaryTree;
        this.right.setParent(this);
    }

    protected void setParent(BinaryTree binaryTree) {
        this.parent = binaryTree;
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.left().size() + this.right().size() + 1;
    }

    public BinaryTree root() {
        if (this.parent() == null) {
            return this;
        }
        return this.parent().root();
    }

    public int height() {
        if (this.isEmpty()) {
            return -1;
        }
        return 1 + Math.max(this.left.height(), this.right.height());
    }

    public int depth() {
        if (this.parent() == null) {
            return 0;
        }
        return 1 + this.parent.depth();
    }

    public boolean isFull() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.left().height() != this.right().height()) {
            return false;
        }
        return this.left().isFull() && this.right().isFull();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isComplete() {
        if (this.isEmpty()) {
            return true;
        }
        int n = this.left().height();
        int n2 = this.right().height();
        boolean bl = this.left().isFull();
        boolean bl2 = this.right().isFull();
        boolean bl3 = this.left().isComplete();
        boolean bl4 = this.right().isComplete();
        if (bl && bl4 && n == n2) {
            return true;
        }
        return bl3 && bl2 && n == n2 + 1;
    }

    public boolean isBalanced() {
        if (this.isEmpty()) {
            return true;
        }
        return Math.abs(this.left().height() - this.right().height()) <= 1 && this.left().isBalanced() && this.right().isBalanced();
    }

    public Iterator iterator() {
        return this.inorderIterator();
    }

    public AbstractIterator preorderIterator() {
        return new BTPreorderIterator(this);
    }

    public AbstractIterator inorderIterator() {
        return new BTInorderIterator(this);
    }

    public AbstractIterator postorderIterator() {
        return new BTPostorderIterator(this);
    }

    public AbstractIterator levelorderIterator() {
        return new BTLevelorderIterator(this);
    }

    protected void rotateRight() {
        BinaryTree binaryTree = this.parent();
        BinaryTree binaryTree2 = this.left();
        boolean bl = binaryTree != null;
        boolean bl2 = this.isLeftChild();
        this.setLeft(binaryTree2.right());
        binaryTree2.setRight(this);
        if (bl) {
            if (bl2) {
                binaryTree.setLeft(binaryTree2);
            } else {
                binaryTree.setRight(binaryTree2);
            }
        }
    }

    protected void rotateLeft() {
        BinaryTree binaryTree = this.parent();
        BinaryTree binaryTree2 = this.right();
        boolean bl = binaryTree != null;
        boolean bl2 = this.isRightChild();
        this.setRight(binaryTree2.left());
        binaryTree2.setLeft(this);
        if (bl) {
            if (bl2) {
                binaryTree.setRight(binaryTree2);
            } else {
                binaryTree.setLeft(binaryTree2);
            }
        }
    }

    public boolean isLeftChild() {
        if (this.parent() == null) {
            return false;
        }
        return this == this.parent().left();
    }

    public boolean isRightChild() {
        if (this.parent() == null) {
            return false;
        }
        return this == this.parent().right();
    }

    public Object value() {
        return this.val;
    }

    public void setValue(Object object) {
        this.val = object;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = this.left().hashCode() + this.right().hashCode();
        if (this.value() != null) {
            n += this.value().hashCode();
        }
        return n;
    }

    public String treeString() {
        String string = "";
        int n = 0;
        while (n < this.depth()) {
            string = string + "\t|";
            ++n;
        }
        string = string + "<" + this.val + " : " + this.getHand() + ">\n";
        if (this.left != EMPTY) {
            string = string + this.left.treeString();
        }
        if (this.right != EMPTY) {
            string = string + this.right.treeString();
        }
        return string;
    }

    private String getHand() {
        if (this.isRightChild()) {
            return "R";
        }
        if (this.isLeftChild()) {
            return "L";
        }
        return "Root";
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<BinaryTree: empty>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BinaryTree " + this.value());
        if (!this.left().isEmpty()) {
            stringBuffer.append(" " + this.left());
        } else {
            stringBuffer.append(" -");
        }
        if (!this.right().isEmpty()) {
            stringBuffer.append(" " + this.right());
        } else {
            stringBuffer.append(" -");
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

