/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.util.Comparator;
import java.util.Iterator;
import structure.AbstractStructure;
import structure.Assert;
import structure.BinaryTree;
import structure.NaturalComparator;
import structure.OrderedStructure;

public class BinarySearchTree
extends AbstractStructure
implements OrderedStructure {
    protected BinaryTree root = BinaryTree.EMPTY;
    protected int count = 0;
    protected Comparator ordering;

    public BinarySearchTree() {
        this(new NaturalComparator());
    }

    public BinarySearchTree(Comparator comparator) {
        this.ordering = comparator;
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public void clear() {
        this.root = BinaryTree.EMPTY;
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    protected BinaryTree locate(BinaryTree binaryTree, Object object) {
        Object object2 = binaryTree.value();
        if (object2.equals(object)) {
            return binaryTree;
        }
        BinaryTree binaryTree2 = this.ordering.compare(object2, object) < 0 ? binaryTree.right() : binaryTree.left();
        if (binaryTree2.isEmpty()) {
            return binaryTree;
        }
        return this.locate(binaryTree2, object);
    }

    protected BinaryTree predecessor(BinaryTree binaryTree) {
        Assert.pre(!binaryTree.isEmpty(), "No predecessor to middle value.");
        Assert.pre(!binaryTree.left().isEmpty(), "Root has left child.");
        BinaryTree binaryTree2 = binaryTree.left();
        while (!binaryTree2.right().isEmpty()) {
            binaryTree2 = binaryTree2.right();
        }
        return binaryTree2;
    }

    protected BinaryTree successor(BinaryTree binaryTree) {
        Assert.pre(!binaryTree.isEmpty(), "Tree is non-null.");
        Assert.pre(!binaryTree.right().isEmpty(), "Root has right child.");
        BinaryTree binaryTree2 = binaryTree.right();
        while (!binaryTree2.left().isEmpty()) {
            binaryTree2 = binaryTree2.left();
        }
        return binaryTree2;
    }

    public void add(Object object) {
        BinaryTree binaryTree = new BinaryTree(object);
        if (this.root.isEmpty()) {
            this.root = binaryTree;
        } else {
            BinaryTree binaryTree2 = this.locate(this.root, object);
            Object object2 = binaryTree2.value();
            if (this.ordering.compare(object2, object) < 0) {
                binaryTree2.setRight(binaryTree);
            } else if (!binaryTree2.left().isEmpty()) {
                this.predecessor(binaryTree2).setRight(binaryTree);
            } else {
                binaryTree2.setLeft(binaryTree);
            }
        }
        ++this.count;
    }

    public boolean contains(Object object) {
        if (this.root.isEmpty()) {
            return false;
        }
        BinaryTree binaryTree = this.locate(this.root, object);
        return object.equals(binaryTree.value());
    }

    public Object get(Object object) {
        if (this.root.isEmpty()) {
            return null;
        }
        BinaryTree binaryTree = this.locate(this.root, object);
        if (object.equals(binaryTree.value())) {
            return binaryTree.value();
        }
        return null;
    }

    public Object remove(Object object) {
        if (this.isEmpty()) {
            return null;
        }
        if (object.equals(this.root.value())) {
            BinaryTree binaryTree = this.removeTop(this.root);
            --this.count;
            Object object2 = this.root.value();
            this.root = binaryTree;
            return object2;
        }
        BinaryTree binaryTree = this.locate(this.root, object);
        if (object.equals(binaryTree.value())) {
            --this.count;
            BinaryTree binaryTree2 = binaryTree.parent();
            if (binaryTree2.right() == binaryTree) {
                binaryTree2.setRight(this.removeTop(binaryTree));
            } else {
                binaryTree2.setLeft(this.removeTop(binaryTree));
            }
            return binaryTree.value();
        }
        return null;
    }

    protected BinaryTree removeTop(BinaryTree binaryTree) {
        BinaryTree binaryTree2 = binaryTree.left();
        BinaryTree binaryTree3 = binaryTree.right();
        binaryTree.setLeft(BinaryTree.EMPTY);
        binaryTree.setRight(BinaryTree.EMPTY);
        if (binaryTree2.isEmpty()) {
            return binaryTree3;
        }
        if (binaryTree3.isEmpty()) {
            return binaryTree2;
        }
        BinaryTree binaryTree4 = binaryTree2.right();
        if (binaryTree4.isEmpty()) {
            binaryTree2.setRight(binaryTree3);
            return binaryTree2;
        }
        BinaryTree binaryTree5 = binaryTree2;
        while (!binaryTree4.right().isEmpty()) {
            binaryTree5 = binaryTree4;
            binaryTree4 = binaryTree4.right();
        }
        binaryTree5.setRight(binaryTree4.left());
        binaryTree4.setLeft(binaryTree2);
        binaryTree4.setRight(binaryTree3);
        return binaryTree4;
    }

    public Iterator iterator() {
        return this.root.inorderIterator();
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public String treeString() {
        return this.root.treeString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BinarySearchTree:");
        if (!this.root.isEmpty()) {
            stringBuffer.append(this.root);
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

