/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.AbstractIterator;
import structure.BinaryTree;
import structure.Stack;
import structure.StackList;

class BTPreorderIterator
extends AbstractIterator {
    protected BinaryTree root;
    protected Stack todo = new StackList();

    public BTPreorderIterator(BinaryTree binaryTree) {
        this.root = binaryTree;
        this.reset();
    }

    public void reset() {
        this.todo.clear();
        if (this.root != null) {
            this.todo.push(this.root);
        }
    }

    public boolean hasNext() {
        return !this.todo.isEmpty();
    }

    public Object get() {
        return ((BinaryTree)this.todo.getFirst()).value();
    }

    public Object next() {
        BinaryTree binaryTree = (BinaryTree)this.todo.pop();
        Object object = binaryTree.value();
        if (!binaryTree.right().isEmpty()) {
            this.todo.push(binaryTree.right());
        }
        if (!binaryTree.left().isEmpty()) {
            this.todo.push(binaryTree.left());
        }
        return object;
    }
}

