/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.AbstractIterator;
import structure.BinaryTree;
import structure.Queue;
import structure.QueueList;

class BTLevelorderIterator
extends AbstractIterator {
    protected BinaryTree root;
    protected Queue todo = new QueueList();

    public BTLevelorderIterator(BinaryTree binaryTree) {
        this.root = binaryTree;
        this.reset();
    }

    public void reset() {
        this.todo.clear();
        if (!this.root.isEmpty()) {
            this.todo.enqueue(this.root);
        }
    }

    public boolean hasNext() {
        return !this.todo.isEmpty();
    }

    public Object get() {
        return ((BinaryTree)this.todo.getFirst()).value();
    }

    public Object next() {
        BinaryTree binaryTree = (BinaryTree)this.todo.dequeue();
        Object object = binaryTree.value();
        if (!binaryTree.left().isEmpty()) {
            this.todo.enqueue(binaryTree.left());
        }
        if (!binaryTree.right().isEmpty()) {
            this.todo.enqueue(binaryTree.right());
        }
        return object;
    }
}

