/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.AbstractIterator;
import structure.BinaryTree;
import structure.Stack;
import structure.StackList;

class BTInorderIterator
extends AbstractIterator {
    protected BinaryTree root;
    protected Stack todo = new StackList();

    public BTInorderIterator(BinaryTree binaryTree) {
        this.root = binaryTree;
        this.reset();
    }

    public void reset() {
        this.todo.clear();
        BinaryTree binaryTree = this.root;
        while (binaryTree != BinaryTree.EMPTY) {
            this.todo.push(binaryTree);
            binaryTree = binaryTree.left();
        }
    }

    public boolean hasNext() {
        return !this.todo.isEmpty();
    }

    public Object get() {
        return ((BinaryTree)this.todo.getFirst()).value();
    }

    public Object next() {
        BinaryTree binaryTree = (BinaryTree)this.todo.pop();
        Object object = binaryTree.value();
        if (!binaryTree.right().isEmpty()) {
            BinaryTree binaryTree2 = binaryTree.right();
            do {
                this.todo.push(binaryTree2);
            } while (!(binaryTree2 = binaryTree2.left()).isEmpty());
        }
        return object;
    }
}

