/*
 * Decompiled with CFR 0.152.
 */
package structure;

import structure.AbstractIterator;

public class ArrayIterator
extends AbstractIterator {
    protected Object[] data;
    protected int head;
    protected int count;
    protected int current;
    protected int remaining;

    public ArrayIterator(Object[] objectArray) {
        this(objectArray, 0, objectArray.length);
    }

    public ArrayIterator(Object[] objectArray, int n, int n2) {
        this.data = objectArray;
        this.head = n;
        this.count = n2;
        this.reset();
    }

    public void reset() {
        this.current = this.head;
        this.remaining = this.count;
    }

    public boolean hasNext() {
        return this.remaining > 0;
    }

    public Object next() {
        Object object = this.data[this.current];
        this.current = (this.current + 1) % this.data.length;
        --this.remaining;
        return object;
    }

    public Object get() {
        return this.data[this.current];
    }

    public static void main(String[] stringArray) {
        String string = "For loops are much faster than iterators";
        Object[] objectArray = new String[10000000];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = string;
            ++n;
        }
        long l = System.currentTimeMillis();
        ArrayIterator arrayIterator = new ArrayIterator(objectArray);
        while (arrayIterator.hasNext()) {
            arrayIterator.next();
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.println("Iteration over array took " + l3 + " milliseconds to perform.");
        l = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < objectArray.length) {
            ++n2;
        }
        l2 = System.currentTimeMillis();
        long l4 = l2 - l;
        System.out.println("Looping over array took " + (l2 - l) + " milliseconds to perform.");
        System.out.println("Iterators are " + (double)l3 / (double)l4 + " times " + "slower than loops.");
    }
}

