/*
 * Decompiled with CFR 0.152.
 */
package doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import doclets.Conditioned;
import doclets.ConfigurationStandard;
import doclets.SerialFieldSubWriter;
import doclets.SerialMethodSubWriter;
import doclets.SubWriterHolderWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class SerializedFormWriter
extends SubWriterHolderWriter {
    public SerializedFormWriter(String string) throws IOException, DocletAbortException {
        super(string);
    }

    public static void generate(RootDoc rootDoc) throws DocletAbortException {
        String string = "serialized-form.html";
        try {
            SerializedFormWriter serializedFormWriter = new SerializedFormWriter(string);
            serializedFormWriter.generateSerializedFormFile(rootDoc);
            ((PrintWriter)((Object)serializedFormWriter)).close();
        }
        catch (IOException iOException) {
            Conditioned.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    public void generateSerializedFormFile(RootDoc rootDoc) {
        this.printHeader(this.getText("doclet.Serialized_Form"));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.printText("doclet.Serialized_Form");
        this.h1End();
        this.centerEnd();
        this.generateContents(rootDoc);
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void generateContents(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = Conditioned.configuration().packages;
        Object[] objectArray = rootDoc.specifiedClasses();
        boolean bl = true;
        int n = 0;
        while (n < packageDocArray.length) {
            Object[] objectArray2 = packageDocArray[n].allClasses();
            boolean bl2 = true;
            Arrays.sort(objectArray2);
            int n2 = 0;
            while (n2 < objectArray2.length) {
                Object object = objectArray2[n2];
                if (object.isClass() && object.isSerializable()) {
                    if (bl2) {
                        this.hr(4, "noshade");
                        this.printPackageName(packageDocArray[n].name());
                        bl2 = false;
                    }
                    bl = false;
                    this.printSerialMemberInfo((ClassDoc)object);
                }
                ++n2;
            }
            ++n;
        }
        if (objectArray.length > 0) {
            Arrays.sort(objectArray);
            int n3 = 0;
            while (n3 < objectArray.length) {
                Object object = objectArray[n3];
                if (object.isClass() && object.isSerializable()) {
                    if (!bl) {
                        this.hr(4, "noshade");
                    }
                    bl = false;
                    this.printSerialMemberInfo((ClassDoc)object);
                }
                ++n3;
            }
        }
    }

    protected void printSerialMemberInfo(ClassDoc classDoc) {
        String string = this.getQualifiedClassLink(classDoc);
        this.anchor(classDoc.qualifiedName());
        this.printClassName(this.getText("doclet.Class_0_implements_serializable", string));
        this.printSerialMembers(classDoc);
        this.p();
    }

    protected void printSerialMembers(ClassDoc classDoc) {
        new SerialMethodSubWriter(this, classDoc).printMembers();
        new SerialFieldSubWriter(this, classDoc).printMembers();
    }

    protected void printPackageName(String string) {
        this.tableHeader();
        this.tdAlign("center");
        this.font("+2");
        this.boldText("doclet.Package");
        ((PrintWriter)((Object)this)).print(' ');
        this.bold(string);
        this.tableFooter();
    }

    protected void printClassName(String string) {
        this.tableHeader();
        this.tdColspan(2);
        this.font("+2");
        this.bold(string);
        this.tableFooter();
    }

    protected void tableHeader() {
        this.tableIndexSummary();
        this.trBgcolorStyle("#CCCCFF", "TableSubHeadingColor");
    }

    protected void tableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
        this.p();
    }
}

