/*
 * Decompiled with CFR 0.152.
 */
package doclets;

import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import doclets.AbstractPackageIndexWriter;
import doclets.Conditioned;
import doclets.ConfigurationStandard;
import doclets.Group;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

public class PackageIndexWriter
extends AbstractPackageIndexWriter {
    private RootDoc root;
    private Map groupPackageMap;
    private List groupList;

    public PackageIndexWriter(String string, RootDoc rootDoc) throws IOException {
        super(string);
        this.root = rootDoc;
        this.groupPackageMap = Group.groupPackages(this.packages);
        this.groupList = Group.getGroupList();
    }

    public static void generate(RootDoc rootDoc) throws DocletAbortException {
        String string = "overview-summary.html";
        try {
            PackageIndexWriter packageIndexWriter = new PackageIndexWriter(string, rootDoc);
            packageIndexWriter.generatePackageIndexFile();
            ((PrintWriter)((Object)packageIndexWriter)).close();
        }
        catch (IOException iOException) {
            Conditioned.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void printIndexRow(PackageDoc packageDoc) {
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(20);
        this.bold();
        this.printPackageLink(packageDoc);
        this.boldEnd();
        this.summaryRowEnd();
        this.summaryRow(0);
        this.printSummaryComment((Doc)packageDoc);
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void generateIndex() {
        int n = 0;
        while (n < this.groupList.size()) {
            String string = (String)this.groupList.get(n);
            List list = (List)this.groupPackageMap.get(string);
            if (list != null && list.size() > 0) {
                this.printIndexContents(list.toArray(new PackageDoc[list.size()]), string);
            }
            ++n;
        }
    }

    protected void printOverviewHeader() {
        if (this.root.inlineTags().length > 0) {
            this.printSummaryComment((Doc)this.root);
            this.p();
            this.bold(this.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "overview_description", this.getText("doclet.Description"), true);
            this.p();
        }
    }

    protected void printIndexHeader(String string) {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.bold(string);
        this.tableHeaderEnd();
    }

    protected void printIndexFooter() {
        this.tableEnd();
        this.p();
        this.space();
    }

    protected void printOverviewComment() {
        if (this.root.inlineTags().length > 0) {
            this.anchor("overview_description");
            this.p();
            this.printInlineComment((Doc)this.root);
            this.p();
        }
    }

    protected void printOverview() throws IOException {
        this.printOverviewComment();
        this.generateTagInfo((Doc)this.root);
    }

    protected void printNavigationBarHeader() {
        this.navLinks(true);
        this.hr();
        this.printConfigurationTitle();
    }

    protected void printNavigationBarFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
    }
}

