/*
 * Decompiled with CFR 0.152.
 */
package doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.IndexBuilder;
import com.sun.tools.doclets.Util;
import doclets.Conditioned;
import doclets.ConfigurationStandard;
import doclets.HtmlStandardWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class AllClassesFrameWriter
extends HtmlStandardWriter {
    protected IndexBuilder indexbuilder;

    public AllClassesFrameWriter(String string, IndexBuilder indexBuilder) throws IOException, DocletAbortException {
        super(string);
        this.indexbuilder = indexBuilder;
    }

    public static void generate(IndexBuilder indexBuilder) throws DocletAbortException {
        String string = "allclasses-frame.html";
        try {
            AllClassesFrameWriter allClassesFrameWriter = new AllClassesFrameWriter(string, indexBuilder);
            allClassesFrameWriter.generateAllClassesFile();
            ((PrintWriter)((Object)allClassesFrameWriter)).close();
        }
        catch (IOException iOException) {
            Conditioned.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generateAllClassesFile() throws IOException {
        String string = this.getText("doclet.All_Classes");
        this.printHeader(string);
        this.printAllClassesTableHeader();
        this.printAllClasses();
        this.printAllClassesTableFooter();
        this.printBodyHtmlEnd();
    }

    protected void printAllClasses() {
        int n = 0;
        while (n < this.indexbuilder.elements().length) {
            Character c = (Character)this.indexbuilder.elements()[n];
            this.generateContents(this.indexbuilder.getMemberList(c));
            ++n;
        }
    }

    protected void generateContents(List list) {
        int n = 0;
        while (n < list.size()) {
            ClassDoc classDoc = (ClassDoc)list.get(n);
            if (Util.isCoreClass((ClassDoc)classDoc)) {
                String string = this.italicsClassName(classDoc, false);
                this.printTargetHyperLink(this.pathToClass(classDoc), "classFrame", string);
                this.br();
            }
            ++n;
        }
    }

    protected void printAllClassesTableHeader() {
        this.fontSizeStyle("+1", "FrameHeadingFont");
        this.boldText("doclet.All_Classes");
        this.fontEnd();
        this.br();
        this.table();
        this.tr();
        this.tdNowrap();
        this.fontStyle("FrameItemFont");
    }

    protected void printAllClassesTableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }
}

