package be.arci.pub;

import be.arci.applet.*;
import java.util.Properties;
import java.text.MessageFormat;
import java.net.URL;
import java.io.IOException;
/**Implementation of Browser that delegates to the guest environment through a
 * configurable command line. The command lines are retrieved from the
 * file <tt>be/arci/pub/ExecBrowser.properties</tt> throuhg Applicet's
 * <tt>getI18NSet</tt> function. Properties are named as the Operating 
 * System, and their value is the command to run, with {0} to be replaced by the
 * URL of the document, and {1} by the target window (formatting done by 
 * <tt>java.text.MessageFormat</tt>)
 * <P>
 * As an example, the ExecBrowser.properties might contain the following lines:
 * <PRE>
 *    #we currently do not know how to pass target to netscape
 *    Solaris=netscape -remote openURL({0})
 *    SunOS=netscape -remote openURL({0})
 *    Windows=start {0}
 * </PRE>
 * <P>
 * We supply this Browser implementation as a free service to all Applicet users. 
 * You are allowed to modify this source code, provided you move the class out of 
 * the <tt>be.arci</tt> package hierarchy.
 * <P>
 * <STRONG>Currently the sTarget argument is ignored</STRONG>. 
 * @author Dirk Bosmans
 * @since 03/feb/2000
 * @see Applicet.I18NDelegate#getI18NSet(Class execbrowser)
 * @see <A HREF=doc-files/netscape.html>Netscape commandline options</A>
 * @see "be/arci/pub/ExecBrowser.properties"
 */
public class ExecBrowser implements Browser
{
 /**The command to launch the browser in the guest OS.   */
 private static MessageFormat mfLaunch;
 /*javadoc copies docs from Browser*/
 public void showDocument(Applicet application, URL urlDocument, String sTarget)
 {
  if (mfLaunch == null)  
  {//don't really need the I18N functionality, but it allows easy loading of our .properties file
   //anyway, take care not to disturb Applicet's I18NDelegate, obtain an I18N set for direct access
   Properties prpBrowseCommands = application.getI18NDelegate().getI18NSet(ExecBrowser.class);
   String sOS = System.getProperty("os.name");
   //patch the many Windows versions to one generic "Windows" OS
   if (sOS.startsWith("Windows") && prpBrowseCommands.getProperty(sOS) == null)
    sOS = "Windows"; 
   // Get command syntax, with a reasonable default that will run on many platforms (provided netscape is in the path)
   String sLaunch = prpBrowseCommands.getProperty(sOS, "netscape {0}");
   mfLaunch = new MessageFormat(sLaunch);
  }
  try  //we cannot throw up, because java.applet.AppletContext forbids so
  {// Format and execute command
   Runtime.getRuntime().exec(mfLaunch.format(new Object[] {urlDocument.toExternalForm(), sTarget}));
  } catch (IOException e) { e.printStackTrace(); }
 }
}
