package be.arci.pub;

import be.arci.applet.*;
import edu.stanford.ejalbert.*;
import java.net.URL;
import java.io.IOException;
/**Implementation of Browser that delegates to Eric Albert's <tt>BrowserLauncher</tt>.
 * <P>
 * We supply this Browser implementation as a free service to all Applicet users. 
 * You are allowed to modify this source code, provided you move the class out of 
 * the <tt>be.arci</tt> package hierarchy.
 * <P>
 * <STRONG>Currently the sTarget argument is ignored</STRONG>. 
 * @author Dirk Bosmans
 * @since 01/feb/2000
 * @see BrowserLauncher BrowserLauncher class
 * @see <A HREF=http://www.stanford.edu/~ejalbert/software/BrowserLauncher/>Eric 
 * Albert's <tt>BrowserLauncher</tt> website</A>
 */
public class EricAlbertBrowser implements Browser
{
 /*javadoc copies docs from Browser*/
 public void showDocument(Applicet application, URL urlDocument, String sTarget)
 {
  try {  //we cannot throw up, because java.applet.AppletContext forbids so
   BrowserLauncher.openURL(urlDocument.toExternalForm()); 
  } catch (IOException e) { e.printStackTrace(); }
 }
}
