package be.arci.pub;

import java.awt.Color;
/**Convenience class that contains one single method to decode Applicet 
 * parameter Strings to a Color value, which is quite commonly required (some
 * IDE code generators even put such a method by default into your
 * applet's java code).
 * <P>
 * We supply this class as a free service to all Applicet users. 
 * You are allowed to modify this source code, provided you move the class out of 
 * the <tt>be.arci</tt> package hierarchy.
 * <P>
 * @author Dirk Bosmans
 * @since 05/feb/2000
 */
public class ColorParameter
{
 /**no need to instantiate it.  */
 private ColorParameter() {} 
 /**Convenience method to convert an HTML-style hexadimal "RRGGBB" or 
  * "#RRGGBB" color number or one of the predefined Color names 
  * (case-insensitive) to an <tt>awt.Color</tt> object, or null if 
  * no color is matched. The predefined Color names are
  * <P><UL>
  * <LI>"black"
  * <LI>"white"
  * <LI>"blue"
  * <LI>"cyan"
  * <LI>"darkGray"
  * <LI>"gray"
  * <LI>"green"
  * <LI>"lightGray"
  * <LI>"magenta"
  * <LI>"orange"
  * <LI>"pink"
  * <LI>"red"
  * <LI>"yellow" (my favorite color, though not for applets)
  * </UL><P>
  * @param sColor The color name or number. May be null or an empty String.
  */
 public static Color getColor(String sColor)
 {
  if (sColor != null && sColor.length() > 0)
  {//cannot just put to lowerCase, some names have uppercase
   if ("black".equalsIgnoreCase(sColor))
    return Color.black;
   if ("white".equalsIgnoreCase(sColor))
    return Color.white;
   if ("blue".equalsIgnoreCase(sColor))
    return Color.blue;
   if ("cyan".equalsIgnoreCase(sColor))
    return Color.cyan;
   if ("darkGray".equalsIgnoreCase(sColor))
    return Color.darkGray;
   if ("gray".equalsIgnoreCase(sColor))
    return Color.gray;
   if ("green".equalsIgnoreCase(sColor))
    return Color.green;
   if ("lightGray".equalsIgnoreCase(sColor))
    return Color.lightGray;
   if ("magenta".equalsIgnoreCase(sColor))
    return Color.magenta;
   if ("orange".equalsIgnoreCase(sColor))
    return Color.orange;
   if ("pink".equalsIgnoreCase(sColor))
    return Color.pink;
   if ("red".equalsIgnoreCase(sColor))
    return Color.red;
   if ("yellow".equalsIgnoreCase(sColor))
    return Color.yellow;
   if (sColor.charAt(0) == '#')//real HTML-style
    sColor = sColor.substring(1);
   if (sColor.length() == 6 && Character.digit(sColor.charAt(0), 16) >= 0) //we do not allow +RGGBB or -RRGGBB
   {
    try { return new Color(Integer.parseInt(sColor, 16)); } catch (Throwable t) {}
   }
  }
  return null;
 }
}
