/*
 * Decompiled with CFR 0.152.
 */
package net.datastructures;

import java.util.Comparator;
import net.datastructures.DefaultComparator;
import net.datastructures.EmptyPriorityQueueException;
import net.datastructures.Entry;
import net.datastructures.InvalidKeyException;
import net.datastructures.NodePositionList;
import net.datastructures.Position;
import net.datastructures.PositionList;
import net.datastructures.PriorityQueue;

public class SortedListPriorityQueue<K, V>
implements PriorityQueue<K, V> {
    protected PositionList<Entry<K, V>> entries;
    protected Comparator<K> c;
    protected Position<Entry<K, V>> actionPos;

    public SortedListPriorityQueue() {
        this.entries = new NodePositionList<Entry<K, V>>();
        this.c = new DefaultComparator<K>();
    }

    public SortedListPriorityQueue(Comparator<K> comparator) {
        this.entries = new NodePositionList<Entry<K, V>>();
        this.c = comparator;
    }

    public SortedListPriorityQueue(PositionList<Entry<K, V>> positionList, Comparator<K> comparator) {
        this.entries = positionList;
        this.c = comparator;
    }

    public void setComparator(Comparator<K> comparator) throws IllegalStateException {
        if (!this.isEmpty()) {
            throw new IllegalStateException("Priority queue is not empty");
        }
        this.c = comparator;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Entry<K, V> min() throws EmptyPriorityQueueException {
        if (this.entries.isEmpty()) {
            throw new EmptyPriorityQueueException("priority queue is empty");
        }
        return this.entries.first().element();
    }

    @Override
    public Entry<K, V> insert(K k, V v) throws InvalidKeyException {
        this.checkKey(k);
        MyEntry<K, V> myEntry = new MyEntry<K, V>(k, v);
        this.insertEntry(myEntry);
        return myEntry;
    }

    protected void insertEntry(Entry<K, V> entry) {
        if (this.entries.isEmpty()) {
            this.entries.addFirst(entry);
            this.actionPos = this.entries.first();
        } else if (this.c.compare(entry.getKey(), this.entries.last().element().getKey()) > 0) {
            this.entries.addLast(entry);
            this.actionPos = this.entries.last();
        } else {
            Position<Entry<K, V>> position = this.entries.first();
            while (this.c.compare(entry.getKey(), position.element().getKey()) > 0) {
                position = this.entries.next(position);
            }
            this.entries.addBefore(position, entry);
            this.actionPos = this.entries.prev(position);
        }
    }

    @Override
    public Entry<K, V> removeMin() throws EmptyPriorityQueueException {
        if (this.entries.isEmpty()) {
            throw new EmptyPriorityQueueException("priority queue is empty");
        }
        return this.entries.remove(this.entries.first());
    }

    protected boolean checkKey(K k) throws InvalidKeyException {
        boolean bl;
        try {
            bl = this.c.compare(k, k) == 0;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidKeyException("key cannot be compared");
        }
        return bl;
    }

    public String toString() {
        return this.entries.toString();
    }

    protected static class MyEntry<K, V>
    implements Entry<K, V> {
        protected K k;
        protected V v;

        public MyEntry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            return this.v;
        }

        public String toString() {
            return "(" + this.k + "," + this.v + ")";
        }
    }
}

